/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.libs.commandapi.wrappers;

import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.scoreboard.DisplaySlot;

public enum ScoreboardSlot implements Keyed
{
    PLAYER_LIST("list", 0),
    SIDEBAR("sidebar", 1),
    LEGACY_BELOW_NAME("belowName", 2),
    BELOW_NAME("below_name", 2),
    SIDEBAR_TEAM_BLACK("sidebar.team.black", 0, ChatColor.BLACK),
    SIDEBAR_TEAM_DARK_BLUE("sidebar.team.dark_blue", 1, ChatColor.DARK_BLUE),
    SIDEBAR_TEAM_DARK_GREEN("sidebar.team.dark_green", 2, ChatColor.DARK_GREEN),
    SIDEBAR_TEAM_DARK_AQUA("sidebar.team.dark_aqua", 3, ChatColor.DARK_AQUA),
    SIDEBAR_TEAM_DARK_RED("sidebar.team.dark_red", 4, ChatColor.DARK_RED),
    SIDEBAR_TEAM_DARK_PURPLE("sidebar.team.dark_purple", 5, ChatColor.DARK_PURPLE),
    SIDEBAR_TEAM_GOLD("sidebar.team.gold", 6, ChatColor.GOLD),
    SIDEBAR_TEAM_GRAY("sidebar.team.gray", 7, ChatColor.GRAY),
    SIDEBAR_TEAM_DARK_GRAY("sidebar.team.dark_gray", 8, ChatColor.DARK_GRAY),
    SIDEBAR_TEAM_BLUE("sidebar.team.blue", 9, ChatColor.BLUE),
    SIDEBAR_TEAM_GREEN("sidebar.team.green", 10, ChatColor.GREEN),
    SIDEBAR_TEAM_AQUA("sidebar.team.aqua", 11, ChatColor.AQUA),
    SIDEBAR_TEAM_RED("sidebar.team.red", 12, ChatColor.RED),
    SIDEBAR_TEAM_LIGHT_PURPLE("sidebar.team.light_purple", 13, ChatColor.LIGHT_PURPLE),
    SIDEBAR_TEAM_YELLOW("sidebar.team.yellow", 14, ChatColor.YELLOW),
    SIDEBAR_TEAM_WHITE("sidebar.team.white", 15, ChatColor.WHITE);

    private final String key;
    private final int internal;
    private final ChatColor teamColor;

    private ScoreboardSlot(String key, int internal) {
        this.key = key;
        this.internal = internal;
        this.teamColor = null;
    }

    private ScoreboardSlot(String key, int internal, ChatColor color) {
        this.key = key;
        this.internal = internal;
        this.teamColor = color;
    }

    private static boolean isLegacy() {
        return DisplaySlot.values().length == 3;
    }

    private static boolean isPaper() {
        for (DisplaySlot slot : DisplaySlot.values()) {
            if (!slot.name().startsWith("SIDEBAR_TEAM")) continue;
            return true;
        }
        return false;
    }

    public static ScoreboardSlot ofMinecraft(int i) {
        return switch (i) {
            case 0 -> PLAYER_LIST;
            case 1 -> SIDEBAR;
            case 2 -> BELOW_NAME;
            default -> {
                for (ScoreboardSlot slot : ScoreboardSlot.values()) {
                    if (i - 3 != slot.internal || !slot.hasTeamColor()) continue;
                    yield slot;
                }
                throw new IllegalStateException("Invalid ScoreboardSlot with internal index " + i);
            }
        };
    }

    public static ScoreboardSlot of(DisplaySlot slot) {
        if (ScoreboardSlot.isLegacy()) {
            return switch (slot) {
                case DisplaySlot.PLAYER_LIST -> PLAYER_LIST;
                case DisplaySlot.SIDEBAR -> SIDEBAR;
                case DisplaySlot.BELOW_NAME -> BELOW_NAME;
                default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(slot));
            };
        }
        return switch (slot) {
            case DisplaySlot.PLAYER_LIST -> PLAYER_LIST;
            case DisplaySlot.SIDEBAR -> SIDEBAR;
            case DisplaySlot.BELOW_NAME -> BELOW_NAME;
            default -> ScoreboardSlot.isPaper() ? ScoreboardSlot.valueOf(slot.name()) : ScoreboardSlot.valueOf("SIDEBAR_TEAM_" + slot.name().substring(8));
        };
    }

    public static ScoreboardSlot ofTeamColor(ChatColor color) {
        for (ScoreboardSlot slot : ScoreboardSlot.values()) {
            if (!slot.hasTeamColor() || !slot.teamColor.equals((Object)color)) continue;
            return slot;
        }
        return SIDEBAR;
    }

    public DisplaySlot getDisplaySlot() {
        if (ScoreboardSlot.isLegacy()) {
            return switch (this.ordinal()) {
                case 3 -> DisplaySlot.BELOW_NAME;
                case 0 -> DisplaySlot.PLAYER_LIST;
                case 1 -> DisplaySlot.SIDEBAR;
                default -> DisplaySlot.SIDEBAR;
            };
        }
        if (ScoreboardSlot.isPaper()) {
            return DisplaySlot.valueOf((String)this.name());
        }
        return DisplaySlot.valueOf((String)this.name().replace("TEAM_", ""));
    }

    public ChatColor getTeamColor() {
        return this.teamColor;
    }

    public boolean hasTeamColor() {
        return this.teamColor != null;
    }

    public NamespacedKey getKey() {
        return NamespacedKey.fromString((String)this.key);
    }

    public String toString() {
        return this.key;
    }
}

