/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.libs.messagelib;

import java.util.List;
import java.util.regex.Matcher;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.firedev.emfpinata.libs.messagelib.config.ConfigLoader;
import uk.firedev.emfpinata.libs.messagelib.message.ComponentMessage;
import uk.firedev.emfpinata.libs.messagelib.message.MessageType;

public class Utils {
    public static final MiniMessage MINI_MESSAGE = MiniMessage.builder().postProcessor(component -> component).build();
    public static final LegacyComponentSerializer LEGACY_COMPONENT_SERIALIZER = LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().character('&').hexColors().useUnusualXRepeatedCharacterHexFormat().build();

    public static boolean isLegacy(@NotNull String message) {
        if (message.isEmpty()) {
            return false;
        }
        return MiniMessage.miniMessage().stripTags(message).equals(message);
    }

    @NotNull
    public static Component processString(@NotNull String message) {
        if (message.isEmpty()) {
            return Component.empty();
        }
        if (Utils.isLegacy(message)) {
            return LEGACY_COMPONENT_SERIALIZER.deserialize(message);
        }
        return MINI_MESSAGE.deserialize((Object)message);
    }

    @Nullable
    public static ComponentMessage getFromConfig(@NotNull ConfigLoader<?> loader, @NotNull String path) {
        ConfigLoader<?> section = loader.getSection(path);
        if (section == null) {
            return Utils.fromObject(loader.getObject(path));
        }
        String messageType = section.getString("type");
        MessageType type = MessageType.getFromString(messageType);
        ComponentMessage finalMessage = Utils.fromObject(section.getObject("message"));
        return finalMessage != null ? finalMessage.messageType(type) : null;
    }

    @Nullable
    private static ComponentMessage fromObject(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            List list = (List)object;
            return ComponentMessage.componentMessage(list);
        }
        return ComponentMessage.componentMessage(object.toString());
    }

    public static Component parsePlaceholderAPI(@NotNull Component component, @Nullable OfflinePlayer player) {
        if (!Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return component;
        }
        String stringMessage = (String)MiniMessage.miniMessage().serialize(component);
        Matcher matcher = PlaceholderAPI.getPlaceholderPattern().matcher(stringMessage);
        while (matcher.find()) {
            String matched = matcher.group();
            String parsed = (String)MiniMessage.miniMessage().serialize((Component)LegacyComponentSerializer.legacySection().deserialize(PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)matched)));
            String safeMatched = Matcher.quoteReplacement(matched);
            stringMessage = stringMessage.replaceAll(safeMatched, parsed);
        }
        return MiniMessage.miniMessage().deserialize((Object)stringMessage);
    }
}

