/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.libs.messagelib.message;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.firedev.emfpinata.libs.messagelib.ObjectProcessor;
import uk.firedev.emfpinata.libs.messagelib.Utils;
import uk.firedev.emfpinata.libs.messagelib.message.ComponentMessage;
import uk.firedev.emfpinata.libs.messagelib.message.ComponentSingleMessage;
import uk.firedev.emfpinata.libs.messagelib.message.MessageType;
import uk.firedev.emfpinata.libs.messagelib.replacer.Replacer;

public class ComponentListMessage
extends ComponentMessage {
    private final List<Component> message = new ArrayList<Component>();
    private final MessageType messageType;

    protected ComponentListMessage(@NotNull List<Component> message, @NotNull MessageType messageType) {
        message.stream().map(arg_0 -> ((Component)ROOT).append(arg_0)).forEach(this.message::add);
        this.messageType = messageType;
    }

    protected ComponentListMessage(@NotNull Component message, @NotNull MessageType messageType) {
        this.message.add(ComponentMessage.ROOT.append(message));
        this.messageType = messageType;
    }

    @NotNull
    public List<Component> get() {
        return new ArrayList<Component>(this.message);
    }

    @NotNull
    public List<String> getAsPlainText() {
        return this.message.stream().map(component -> PlainTextComponentSerializer.plainText().serialize(component)).toList();
    }

    @NotNull
    public List<String> getAsJson() {
        return this.message.stream().map(component -> (String)GsonComponentSerializer.gson().serialize(component)).toList();
    }

    @NotNull
    public List<String> getAsLegacy() {
        return this.message.stream().map(component -> LegacyComponentSerializer.legacySection().serialize(component)).toList();
    }

    @NotNull
    public List<String> getAsMiniMessage() {
        return this.message.stream().map(component -> (String)MiniMessage.miniMessage().serialize(component)).toList();
    }

    @Override
    public ComponentListMessage createCopy() {
        return new ComponentListMessage(List.copyOf(this.message), this.messageType);
    }

    @Override
    @NotNull
    public MessageType messageType() {
        return this.messageType;
    }

    @Override
    public ComponentListMessage messageType(@NotNull MessageType messageType) {
        return new ComponentListMessage(this.message, messageType);
    }

    @Override
    public ComponentListMessage append(@NotNull Object append) {
        ArrayList<Component> newMessage = new ArrayList<Component>(this.message);
        newMessage.addAll(ObjectProcessor.process(append).stream().map(arg_0 -> ((Component)ROOT).append(arg_0)).toList());
        return new ComponentListMessage(newMessage, this.messageType);
    }

    public ComponentListMessage appendEachLine(@NotNull Object append) {
        Component resolved = Component.join((JoinConfiguration)JoinConfiguration.newlines(), ObjectProcessor.process(append));
        List<Component> newMessage = this.message.stream().map(line -> new ComponentSingleMessage((Component)line, this.messageType).append(resolved).get()).toList();
        return new ComponentListMessage(newMessage, this.messageType);
    }

    @Override
    public ComponentListMessage prepend(@NotNull Object prepend) {
        ArrayList<Component> newMessage = new ArrayList<Component>(ObjectProcessor.process(prepend).stream().map(arg_0 -> ((Component)ROOT).append(arg_0)).toList());
        newMessage.addAll(this.message);
        return new ComponentListMessage(newMessage, this.messageType);
    }

    public ComponentListMessage prependEachLine(@NotNull Object prepend) {
        Component resolved = Component.join((JoinConfiguration)JoinConfiguration.newlines(), ObjectProcessor.process(prepend));
        List<Component> newMessage = this.message.stream().map(line -> new ComponentSingleMessage((Component)line, this.messageType).prepend(resolved).get()).toList();
        return new ComponentListMessage(newMessage, this.messageType);
    }

    @Override
    public ComponentListMessage replace(@NotNull String placeholder, @Nullable Object replacement) {
        Replacer replacer = Replacer.replacer().addReplacement(placeholder, replacement);
        return new ComponentListMessage(replacer.apply(this.message), this.messageType);
    }

    public ComponentListMessage replaceWithListInsertion(@NotNull String placeholder, @Nullable Object replacement) {
        Replacer replacer = Replacer.replacer().addReplacement(placeholder, replacement);
        return new ComponentListMessage(replacer.applyWithListInsertion(this.message), this.messageType);
    }

    @Override
    public ComponentListMessage replace(@NotNull Map<String, ?> replacements) {
        Replacer replacer = Replacer.replacer().addReplacements(replacements);
        return new ComponentListMessage(replacer.apply(this.message), this.messageType);
    }

    public ComponentListMessage replaceWithListInsertion(@NotNull Map<String, ?> replacements) {
        Replacer replacer = Replacer.replacer().addReplacements(replacements);
        return new ComponentListMessage(replacer.applyWithListInsertion(this.message), this.messageType);
    }

    @Override
    public ComponentListMessage replace(@Nullable Replacer replacer) {
        if (replacer == null) {
            return this;
        }
        return new ComponentListMessage(replacer.apply(this.message), this.messageType);
    }

    public ComponentListMessage replaceWithListInsertion(@Nullable Replacer replacer) {
        if (replacer == null) {
            return this;
        }
        return new ComponentListMessage(replacer.applyWithListInsertion(this.message), this.messageType);
    }

    @Override
    public ComponentListMessage parsePlaceholderAPI(@Nullable OfflinePlayer player) {
        if (!Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return this;
        }
        return new ComponentListMessage(this.message.stream().map(component -> Utils.parsePlaceholderAPI(component, player)).toList(), this.messageType);
    }

    @Override
    public boolean isEmpty() {
        return this.message.isEmpty();
    }

    @Override
    public int getLength() {
        return this.message.size();
    }

    public List<ComponentSingleMessage> toSingleMessages() {
        return this.message.stream().map(line -> new ComponentSingleMessage((Component)line, this.messageType)).toList();
    }

    public ComponentListMessage edit(@NotNull Function<List<Component>, List<Component>> editor) {
        List<Component> newMessage = editor.apply(new ArrayList<Component>(this.message));
        return new ComponentListMessage(newMessage, this.messageType);
    }

    public ComponentListMessage editAllLines(@NotNull Function<ComponentSingleMessage, ComponentSingleMessage> editor) {
        List<Component> newMessage = this.message.stream().map(line -> (ComponentSingleMessage)editor.apply(new ComponentSingleMessage((Component)line, this.messageType))).filter(Objects::nonNull).map(ComponentSingleMessage::get).toList();
        return new ComponentListMessage(newMessage, this.messageType);
    }

    @Override
    public void send(@Nullable Audience audience) {
        this.message.forEach(component -> this.messageType.send(audience, (Component)component));
    }

    @Override
    public void send(@NotNull List<Audience> audienceList) {
        audienceList.forEach(this::send);
    }

    @Override
    public void broadcast() {
        this.message.forEach(Bukkit::broadcast);
    }
}

