/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.libs.messagelib.message;

import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum MessageType {
    CHAT,
    ACTION_BAR,
    TITLE,
    SUBTITLE;


    public void send(@Nullable Audience audience, @NotNull Component message) {
        if (audience == null) {
            return;
        }
        switch (this) {
            case CHAT: {
                audience.sendMessage(message);
                break;
            }
            case ACTION_BAR: {
                audience.sendActionBar(message);
                break;
            }
            case TITLE: {
                Title title = Title.title((Component)message, (Component)Component.empty());
                audience.showTitle(title);
                break;
            }
            case SUBTITLE: {
                Title title = Title.title((Component)Component.empty(), (Component)message);
                audience.showTitle(title);
            }
        }
    }

    @NotNull
    public static MessageType getFromString(@Nullable String type) {
        if (type == null) {
            return CHAT;
        }
        try {
            return MessageType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return CHAT;
        }
    }
}

