/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.libs.messagelib.replacer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.firedev.emfpinata.libs.messagelib.ObjectProcessor;
import uk.firedev.emfpinata.libs.messagelib.message.ComponentMessage;
import uk.firedev.emfpinata.libs.messagelib.message.ComponentSingleMessage;

public class Replacer {
    private final Map<String, Object> replacements = new HashMap<String, Object>();

    private Replacer() {
    }

    public static Replacer replacer() {
        return new Replacer();
    }

    public Replacer addReplacement(@NotNull String string, @Nullable Object replacement) {
        this.replacements.put(string, replacement);
        return this;
    }

    public Replacer addReplacements(@NotNull Map<String, ?> replacements) {
        this.replacements.putAll(replacements);
        return this;
    }

    public Replacer merge(Replacer ... others) {
        for (Replacer other : others) {
            if (other == this) continue;
            this.replacements.putAll(other.replacements);
        }
        return this;
    }

    public Replacer clear() {
        this.replacements.clear();
        return this;
    }

    public Component apply(@NotNull Component component) {
        for (Map.Entry<String, Object> entry : this.replacements.entrySet()) {
            Component replacement = Component.join((JoinConfiguration)JoinConfiguration.newlines(), ObjectProcessor.process(entry.getValue()));
            component = component.replaceText(builder -> builder.matchLiteral((String)entry.getKey()).replacement((ComponentLike)replacement));
        }
        return component;
    }

    public List<Component> apply(@NotNull List<Component> components) {
        return components.stream().map(this::apply).toList();
    }

    public List<Component> applyWithListInsertion(@NotNull List<Component> components) {
        ArrayList<Component> newList = new ArrayList<Component>();
        for (Component component : components) {
            boolean replaced = false;
            for (Map.Entry<String, Object> entry : this.replacements.entrySet()) {
                ComponentSingleMessage single = ComponentMessage.componentMessage(component);
                if (!single.containsString(entry.getKey())) continue;
                newList.addAll(ObjectProcessor.process(entry.getValue()));
                replaced = true;
                break;
            }
            if (replaced) continue;
            newList.add(component);
        }
        return newList;
    }
}

