/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.pinata;

import dev.dejvokep.boostedyaml.block.implementation.Section;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.firedev.emfpinata.Keys;
import uk.firedev.emfpinata.Utils;
import uk.firedev.emfpinata.api.EntityLoader;
import uk.firedev.emfpinata.config.ConfigBase;
import uk.firedev.emfpinata.libs.messagelib.replacer.Replacer;
import uk.firedev.emfpinata.pinata.config.AwareEntityConfig;
import uk.firedev.emfpinata.pinata.config.DisplayNameEntityConfig;
import uk.firedev.emfpinata.pinata.config.GlowColorEntityConfig;
import uk.firedev.emfpinata.pinata.config.GlowingEntityConfig;
import uk.firedev.emfpinata.pinata.config.HealthEntityConfig;
import uk.firedev.emfpinata.pinata.config.SilentEntityConfig;
import uk.firedev.emfpinata.pinata.loader.MythicEntityLoader;
import uk.firedev.emfpinata.pinata.loader.VanillaEntityLoader;

public class PinataFactory
extends ConfigBase {
    @NotNull
    private final Section config;
    private Consumer<Entity> finalChanges = null;
    @NotNull
    private final EntityLoader entityLoader;
    @NotNull
    private final String pinataId;
    private final AwareEntityConfig awareness;
    private final DisplayNameEntityConfig displayName;
    private final GlowColorEntityConfig glowColor;
    private final GlowingEntityConfig glowing;
    private final HealthEntityConfig health;
    private final SilentEntityConfig silent;

    protected PinataFactory(@NotNull Section section, @NotNull String pinataId) {
        this.config = section;
        this.pinataId = pinataId;
        this.awareness = new AwareEntityConfig(this.config);
        this.displayName = new DisplayNameEntityConfig(this.config);
        this.glowColor = new GlowColorEntityConfig(this.config);
        this.glowing = new GlowingEntityConfig(this.config);
        this.health = new HealthEntityConfig(this.config);
        this.silent = new SilentEntityConfig(this.config);
        this.entityLoader = this.fetchEntityLoader();
    }

    public void spawnEntity(@NotNull Location location) {
        this.spawnEntity(location, null);
    }

    public void spawnEntity(@NotNull Location location, @Nullable Replacer replacements) {
        Entity entity = this.entityLoader.spawn(location);
        this.awareness.apply(entity, replacements);
        this.displayName.apply(entity, replacements);
        this.glowColor.apply(entity, replacements);
        this.glowing.apply(entity, replacements);
        this.health.apply(entity, replacements);
        this.silent.apply(entity, replacements);
        if (this.finalChanges != null) {
            this.finalChanges.accept(entity);
        }
        entity.getPersistentDataContainer().set(Keys.PINATA_KEY, PersistentDataType.STRING, (Object)this.pinataId);
    }

    @NotNull
    public AwareEntityConfig getAwareness() {
        return this.awareness;
    }

    @NotNull
    public DisplayNameEntityConfig getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public GlowColorEntityConfig getGlowColor() {
        return this.glowColor;
    }

    @NotNull
    public GlowingEntityConfig getGlowing() {
        return this.glowing;
    }

    @NotNull
    public HealthEntityConfig getHealth() {
        return this.health;
    }

    @NotNull
    public SilentEntityConfig getSilent() {
        return this.silent;
    }

    public void setFinalChanges(@Nullable Consumer<Entity> finalChanges) {
        this.finalChanges = finalChanges;
    }

    private EntityLoader fetchEntityLoader() {
        String rawValue = this.config.getString("entity-type");
        if (rawValue == null || rawValue.isEmpty()) {
            return new VanillaEntityLoader(EntityType.LLAMA);
        }
        VanillaEntityLoader vanilla = this.getVanillaEntityLoader(rawValue);
        if (vanilla != null) {
            return vanilla;
        }
        MythicEntityLoader mythic = this.getMythicEntityLoader(rawValue);
        if (mythic != null) {
            return mythic;
        }
        return new VanillaEntityLoader(EntityType.LLAMA);
    }

    @Nullable
    public VanillaEntityLoader getVanillaEntityLoader(@NotNull String rawValue) {
        EntityType entityType = Utils.getEnumValue(EntityType.class, rawValue);
        if (entityType == null) {
            return null;
        }
        return new VanillaEntityLoader(entityType);
    }

    @Nullable
    public MythicEntityLoader getMythicEntityLoader(@NotNull String rawValue) {
        String mobName;
        if (rawValue.startsWith("mythic:")) {
            mobName = rawValue.substring("mythic:".length());
        } else if (rawValue.startsWith("mythicmob:")) {
            mobName = rawValue.substring("mythicmob:".length());
        } else {
            return null;
        }
        MythicMob mob = MythicBukkit.inst().getMobManager().getMythicMob(mobName).orElse(null);
        if (mob == null) {
            return null;
        }
        return new MythicEntityLoader(mob);
    }
}

