/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.pinata;

import com.oheers.fish.api.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.logging.Level;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.firedev.emfpinata.EMFPinata;
import uk.firedev.emfpinata.Keys;
import uk.firedev.emfpinata.pinata.Pinata;
import uk.firedev.emfpinata.pinata.PinataRewardType;

public class PinataManager {
    private static final PinataManager instance = new PinataManager();
    private final Random random = new Random();
    private final Map<String, Pinata> pinataMap = new TreeMap<String, Pinata>(String.CASE_INSENSITIVE_ORDER);

    private PinataManager() {
    }

    public static PinataManager getInstance() {
        return instance;
    }

    public void load() {
        this.loadPinatas();
        this.logLoadedItems();
        new PinataRewardType().register();
    }

    public void reload() {
        this.pinataMap.clear();
        this.loadPinatas();
        this.logLoadedItems();
    }

    public void unload() {
        this.pinataMap.clear();
    }

    @NotNull
    public Map<String, Pinata> getPinataMap() {
        return Map.copyOf(this.pinataMap);
    }

    @Nullable
    public Pinata getPinata(@NotNull String name) {
        return this.pinataMap.get(name);
    }

    @Nullable
    public Pinata getPinata(@NotNull Entity entity) {
        String id = (String)entity.getPersistentDataContainer().get(Keys.PINATA_KEY, PersistentDataType.STRING);
        if (id == null) {
            return null;
        }
        return this.getPinata(id);
    }

    @Nullable
    public Pinata getRandomPinata() {
        if (this.pinataMap.isEmpty()) {
            EMFPinata.getInstance().getLogger().warning("There are no loaded Pi\u00f1atas.");
            return null;
        }
        ArrayList<Pinata> values = new ArrayList<Pinata>(this.pinataMap.values());
        int randomIndex = this.random.nextInt(values.size());
        return (Pinata)values.get(randomIndex);
    }

    private void logLoadedItems() {
        EMFPinata.getInstance().getLogger().info("Loaded PinataManager with " + this.pinataMap.size() + " Pinatas.");
    }

    private void loadPinatas() {
        this.pinataMap.clear();
        File pinatasFolder = new File(EMFPinata.getInstance().getDataFolder(), "pinatas");
        if (!pinatasFolder.exists()) {
            this.loadDefaultFiles(pinatasFolder);
        }
        this.regenExampleFile(pinatasFolder);
        List pinataFiles = FileUtil.getFilesInDirectory((File)pinatasFolder, (boolean)true, (boolean)true);
        if (pinataFiles.isEmpty()) {
            return;
        }
        pinataFiles.forEach(file -> {
            Pinata pinata;
            try {
                pinata = new Pinata((File)file);
            }
            catch (InvalidConfigurationException exception) {
                EMFPinata.getInstance().getLogger().warning("Could not load pinata file: " + file.getName() + ". See error below:");
                EMFPinata.getInstance().getLogger().log(Level.WARNING, exception.getMessage(), exception);
                return;
            }
            if (pinata.isDisabled()) {
                return;
            }
            String id = pinata.getId();
            if (this.pinataMap.containsKey(id)) {
                EMFPinata.getInstance().getLogger().warning("A pinata with the id: " + id + " already exists! Skipping.");
                return;
            }
            this.pinataMap.put(id, pinata);
        });
    }

    private void regenExampleFile(@NotNull File targetDirectory) {
        new File(targetDirectory, "_example.yml").delete();
        FileUtil.loadFileOrResource((File)targetDirectory, (String)"_example.yml", (String)"pinatas/_example.yml", (Plugin)EMFPinata.getInstance());
    }

    private void loadDefaultFiles(@NotNull File targetDirectory) {
        EMFPinata.getInstance().getLogger().info("Loading default pinata configs.");
        FileUtil.loadFileOrResource((File)targetDirectory, (String)"default.yml", (String)"pinatas/default.yml", (Plugin)EMFPinata.getInstance());
    }
}

