/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata;

import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import uk.firedev.emfpinata.UpdateChecker;
import uk.firedev.emfpinata.command.MainCommand;
import uk.firedev.emfpinata.config.MessageConfig;
import uk.firedev.emfpinata.libs.bstats.bukkit.Metrics;
import uk.firedev.emfpinata.pinata.PinataListener;
import uk.firedev.emfpinata.pinata.PinataManager;

public final class EMFPinata
extends JavaPlugin {
    private static EMFPinata instance;
    private Metrics metrics = null;

    public void onLoad() {
        this.registerCommands();
    }

    public void onEnable() {
        instance = this;
        MessageConfig.getInstance().reload();
        PinataManager.getInstance().load();
        this.getServer().getPluginManager().registerEvents((Listener)new PinataListener(), (Plugin)this);
        this.registerCommands();
        this.metrics = this.loadMetrics();
        new UpdateChecker(this).checkUpdate().thenAccept(success -> {
            if (success.booleanValue()) {
                this.getLogger().warning("A new update is available! Download it from https://modrinth.com/plugin/emfpinata");
            }
        });
    }

    public void onDisable() {
        PinataManager.getInstance().unload();
    }

    public static EMFPinata getInstance() {
        return instance;
    }

    public void reload() {
        MessageConfig.getInstance().reload();
        PinataManager.getInstance().reload();
    }

    private void registerCommands() {
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> ((Commands)commands.registrar()).register(new MainCommand().get()));
    }

    private Metrics loadMetrics() {
        return new Metrics((Plugin)this, 22866);
    }
}

