/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.api;

import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.util.function.BiConsumer;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.firedev.emfpinata.libs.messagelib.replacer.Replacer;

@ApiStatus.Internal
public abstract class EntityConfig<T> {
    private T def;
    private T override;
    protected final Section section;
    protected boolean enabled = true;

    public EntityConfig(@NotNull Section section) {
        this.section = section;
    }

    @Nullable
    public T getActualValue() {
        if (this.override != null) {
            return this.override;
        }
        T configured = this.getConfiguredValue();
        if (configured == null) {
            return this.def;
        }
        return configured;
    }

    public void apply(@NotNull Entity entity, @Nullable Replacer replacements) {
        if (!this.enabled) {
            return;
        }
        T value = this.getActualValue();
        if (value != null) {
            this.applyToEntity(replacements).accept(entity, (Entity)value);
        }
    }

    public abstract T getConfiguredValue();

    protected abstract BiConsumer<Entity, T> applyToEntity(@Nullable Replacer var1);

    public void setDefault(@Nullable T def) {
        this.def = def;
    }

    public void setOverride(@Nullable T override) {
        this.override = override;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

