/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import org.bukkit.entity.Player;
import uk.firedev.emfpinata.EMFPinata;
import uk.firedev.emfpinata.command.CommandUtils;
import uk.firedev.emfpinata.command.argument.PinataArgument;
import uk.firedev.emfpinata.config.MessageConfig;
import uk.firedev.emfpinata.libs.messagelib.replacer.Replacer;
import uk.firedev.emfpinata.pinata.Pinata;

public class MainCommand {
    public LiteralCommandNode<CommandSourceStack> get() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"emfpinata").requires(stack -> stack.getSender().hasPermission("emfpinata.command"))).then(this.reload())).then(this.pinata())).build();
    }

    private ArgumentBuilder<CommandSourceStack, ?> reload() {
        return Commands.literal((String)"reload").executes(context -> {
            EMFPinata.getInstance().reload();
            MessageConfig.getInstance().getReloadedMessage().send((Audience)((CommandSourceStack)context.getSource()).getSender());
            return 1;
        });
    }

    private ArgumentBuilder<CommandSourceStack, ?> pinata() {
        return Commands.literal((String)"pinata").then(Commands.argument((String)"pinata", (ArgumentType)new PinataArgument()).executes(context -> {
            Player player = CommandUtils.requirePlayer((CommandSourceStack)context.getSource());
            if (player == null) {
                return 1;
            }
            Pinata pinata = (Pinata)((Object)((Object)context.getArgument("pinata", Pinata.class)));
            Replacer replacer = Replacer.replacer().addReplacement("{player}", player.name());
            MessageConfig.getInstance().getPinataSpawnedMessage().send((Audience)player);
            pinata.getFactory().spawnEntity(player.getLocation(), replacer);
            return 1;
        }));
    }
}

