/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.command.argument;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import uk.firedev.emfpinata.pinata.Pinata;
import uk.firedev.emfpinata.pinata.PinataManager;

public class PinataArgument
implements CustomArgumentType.Converted<Pinata, String> {
    private static final DynamicCommandExceptionType UNKNOWN_PINATA = new DynamicCommandExceptionType(obj -> (Message)MessageComponentSerializer.message().serialize((Component)Component.text((String)("Unknown Pi\u00f1ata: " + String.valueOf(obj)))));

    public Pinata convert(String nativeType) throws CommandSyntaxException {
        Pinata pinata = PinataManager.getInstance().getPinata(nativeType);
        if (pinata == null) {
            throw UNKNOWN_PINATA.create((Object)nativeType);
        }
        return pinata;
    }

    @NotNull
    public ArgumentType<String> getNativeType() {
        return StringArgumentType.string();
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        PinataManager.getInstance().getPinataMap().values().stream().map(Pinata::getId).filter(name -> name.toLowerCase().startsWith(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }
}

