/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.libs.messagelib;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.firedev.emfpinata.libs.messagelib.Utils;
import uk.firedev.emfpinata.libs.messagelib.message.ComponentListMessage;
import uk.firedev.emfpinata.libs.messagelib.message.ComponentSingleMessage;

public class ObjectProcessor {
    private static final List<Processor<?>> PROCESSORS = new ArrayList();

    @NotNull
    public static List<Component> process(@NotNull Object object) {
        for (Processor<?> processor : PROCESSORS) {
            List<Component> components = processor.process(object);
            if (components == null) continue;
            return components;
        }
        return List.of(Utils.processString(object.toString()));
    }

    public static <T> void registerProcessor(@NotNull Class<T> clazz, @NotNull Function<T, List<Component>> processor) {
        PROCESSORS.add(new Processor<T>(clazz, processor));
    }

    static {
        ObjectProcessor.registerProcessor(Component.class, List::of);
        ObjectProcessor.registerProcessor(ComponentSingleMessage.class, singleMessage -> List.of(singleMessage.get()));
        ObjectProcessor.registerProcessor(ComponentListMessage.class, ComponentListMessage::get);
    }

    private static class Processor<T> {
        private final Class<T> clazz;
        private final Function<T, List<Component>> processor;

        public Processor(@NotNull Class<T> clazz, @NotNull Function<T, List<Component>> processor) {
            this.clazz = clazz;
            this.processor = processor;
        }

        @Nullable
        public List<Component> process(@NotNull Object object) {
            if (this.clazz.isInstance(object)) {
                return this.processor.apply(this.clazz.cast(object));
            }
            return null;
        }
    }
}

