/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.libs.messagelib.message;

import java.util.List;
import java.util.Map;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.firedev.emfpinata.libs.messagelib.ObjectProcessor;
import uk.firedev.emfpinata.libs.messagelib.Utils;
import uk.firedev.emfpinata.libs.messagelib.config.ConfigLoader;
import uk.firedev.emfpinata.libs.messagelib.message.ComponentListMessage;
import uk.firedev.emfpinata.libs.messagelib.message.ComponentSingleMessage;
import uk.firedev.emfpinata.libs.messagelib.message.MessageType;
import uk.firedev.emfpinata.libs.messagelib.replacer.Replacer;

public abstract class ComponentMessage {
    public static final Component ROOT = Component.empty().applyFallbackStyle(Style.style().color((TextColor)NamedTextColor.WHITE).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE).build());

    protected ComponentMessage() {
    }

    public static ComponentSingleMessage componentMessage(@NotNull Component message, @NotNull MessageType messageType) {
        return new ComponentSingleMessage(message, messageType);
    }

    public static ComponentSingleMessage componentMessage(@NotNull Component message) {
        return ComponentMessage.componentMessage(message, MessageType.CHAT);
    }

    public static ComponentSingleMessage componentMessage(@NotNull Object object, @NotNull MessageType messageType) {
        return ComponentMessage.componentMessage(Component.join((JoinConfiguration)JoinConfiguration.newlines(), ObjectProcessor.process(object)), messageType);
    }

    public static ComponentSingleMessage componentMessage(@NotNull Object object) {
        return ComponentMessage.componentMessage(object, MessageType.CHAT);
    }

    public static ComponentSingleMessage componentMessage(@NotNull String message, @NotNull MessageType messageType) {
        return ComponentMessage.componentMessage(Utils.processString(message), messageType);
    }

    public static ComponentSingleMessage componentMessage(@NotNull String message) {
        return ComponentMessage.componentMessage(message, MessageType.CHAT);
    }

    public static ComponentListMessage componentMessage(@NotNull List<?> message, @NotNull MessageType messageType) {
        return new ComponentListMessage(message.stream().flatMap(object -> ObjectProcessor.process(object).stream()).toList(), messageType);
    }

    public static ComponentListMessage componentMessage(@NotNull List<?> message) {
        return ComponentMessage.componentMessage(message, MessageType.CHAT);
    }

    public static ComponentMessage componentMessage(@NotNull ConfigLoader<?> loader, @NotNull String path) {
        return Utils.getFromConfig(loader, path);
    }

    public static ComponentMessage componentMessage(@NotNull ConfigLoader<?> loader, @NotNull String path, @NotNull String def) {
        ComponentMessage message = Utils.getFromConfig(loader, path);
        return message == null ? ComponentMessage.componentMessage(def) : message;
    }

    public static ComponentMessage componentMessage(@NotNull ConfigLoader<?> loader, @NotNull String path, @NotNull Component def) {
        ComponentMessage message = Utils.getFromConfig(loader, path);
        return message == null ? ComponentMessage.componentMessage(def) : message;
    }

    public ComponentSingleMessage toSingleMessage() {
        ComponentMessage componentMessage = this;
        if (componentMessage instanceof ComponentSingleMessage) {
            ComponentSingleMessage singleMessage = (ComponentSingleMessage)componentMessage;
            return singleMessage;
        }
        componentMessage = this;
        if (componentMessage instanceof ComponentListMessage) {
            ComponentListMessage listMessage = (ComponentListMessage)componentMessage;
            return new ComponentSingleMessage(Component.join((JoinConfiguration)JoinConfiguration.newlines(), listMessage.get()), listMessage.messageType());
        }
        throw new IllegalArgumentException("Invalid ComponentMessage instance provided.");
    }

    public ComponentListMessage toListMessage() {
        ComponentMessage componentMessage = this;
        if (componentMessage instanceof ComponentSingleMessage) {
            ComponentSingleMessage singleMessage = (ComponentSingleMessage)componentMessage;
            return new ComponentListMessage(List.of(singleMessage.get()), singleMessage.messageType());
        }
        componentMessage = this;
        if (componentMessage instanceof ComponentListMessage) {
            ComponentListMessage listMessage = (ComponentListMessage)componentMessage;
            return listMessage;
        }
        throw new IllegalArgumentException("Invalid ComponentMessage instance provided.");
    }

    public abstract ComponentMessage createCopy();

    public abstract MessageType messageType();

    public abstract ComponentMessage messageType(@NotNull MessageType var1);

    public abstract ComponentMessage append(@NotNull Object var1);

    public abstract ComponentMessage prepend(@NotNull Object var1);

    public abstract ComponentMessage replace(@NotNull String var1, @Nullable Object var2);

    public abstract ComponentMessage replace(@NotNull Map<String, ?> var1);

    public abstract ComponentMessage replace(@Nullable Replacer var1);

    public abstract ComponentMessage parsePlaceholderAPI(@Nullable OfflinePlayer var1);

    public abstract boolean isEmpty();

    public abstract int getLength();

    public abstract void send(@Nullable Audience var1);

    public abstract void send(@NotNull List<? extends Audience> var1);

    public abstract void send(Audience ... var1);

    public abstract void broadcast();
}

