/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.libs.messagelib.message;

import java.util.function.BiConsumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.TitlePart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum MessageType {
    CHAT(Audience::sendMessage),
    ACTION_BAR(Audience::sendActionBar),
    TITLE((audience, component) -> audience.sendTitlePart(TitlePart.TITLE, component)),
    SUBTITLE((audience, component) -> audience.sendTitlePart(TitlePart.SUBTITLE, component));

    private final BiConsumer<Audience, Component> consumer;

    private MessageType(BiConsumer<Audience, Component> consumer) {
        this.consumer = consumer;
    }

    public void send(@Nullable Audience audience, @NotNull Component message) {
        if (audience == null) {
            return;
        }
        this.consumer.accept(audience, message);
    }

    @NotNull
    public static MessageType getFromString(@Nullable String type) {
        if (type == null) {
            return CHAT;
        }
        try {
            return MessageType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return CHAT;
        }
    }
}

