/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.pinata;

import com.oheers.fish.api.config.ConfigBase;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.io.File;
import java.util.Objects;
import java.util.logging.Logger;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import uk.firedev.emfpinata.EMFPinata;
import uk.firedev.emfpinata.pinata.PinataFactory;
import uk.firedev.emfpinata.pinata.config.RewardsEntityConfig;

public class Pinata
extends ConfigBase {
    private static final Logger logger = EMFPinata.getInstance().getLogger();
    private final PinataFactory factory;
    private final RewardsEntityConfig rewards;

    public Pinata(@NotNull File file) throws InvalidConfigurationException {
        super(file, (Plugin)EMFPinata.getInstance(), false);
        this.performRequiredConfigChecks();
        this.factory = new PinataFactory((Section)this.getConfig(), this.getId());
        this.rewards = new RewardsEntityConfig((Section)this.getConfig());
    }

    private void performRequiredConfigChecks() throws InvalidConfigurationException {
        if (this.getConfig().getString("id") == null) {
            logger.warning("Pinata invalid: 'id' missing in " + this.getFileName());
            throw new InvalidConfigurationException("An ID has not been found in " + this.getFileName() + ". Please correct this.");
        }
    }

    @NotNull
    public String getId() {
        return Objects.requireNonNull(this.getConfig().getString("id"));
    }

    public boolean isDisabled() {
        return this.getConfig().getBoolean("disabled");
    }

    @NotNull
    public PinataFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public RewardsEntityConfig getRewards() {
        return this.rewards;
    }
}

