/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.pinata.config;

import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.util.function.BiConsumer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.firedev.emfpinata.api.EntityConfig;
import uk.firedev.emfpinata.libs.messagelib.replacer.Replacer;

public class HealthEntityConfig
extends EntityConfig<Integer> {
    public HealthEntityConfig(@NotNull Section section) {
        super(section);
    }

    @Override
    public Integer getConfiguredValue() {
        return this.section.getInt("health");
    }

    @Override
    protected BiConsumer<Entity, Integer> applyToEntity(@Nullable Replacer replacements) {
        return (entity, value) -> {
            if (value == null) {
                return;
            }
            if (value <= 0) {
                value = 1;
            } else if (value > 2048) {
                value = 2048;
            }
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            AttributeInstance attribute = livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (attribute != null) {
                attribute.setBaseValue((double)value.intValue());
                livingEntity.setHealth((double)value.intValue());
            }
        };
    }
}

