/*
 * Decompiled with CFR 0.152.
 */
package io.github.suel_ki.snuffles.common.entity.animal;

import io.github.suel_ki.snuffles.core.registry.SnufflesBlocks;
import io.github.suel_ki.snuffles.core.registry.SnufflesEntityTypes;
import io.github.suel_ki.snuffles.core.registry.SnufflesParticleTypes;
import io.github.suel_ki.snuffles.core.registry.SnufflesSoundEvents;
import io.github.suel_ki.snuffles.core.tags.SnufflesBlockTags;
import io.github.suel_ki.snuffles.core.tags.SnufflesItemTags;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5147;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6868;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class Snuffle
extends class_1429
implements class_5147 {
    private static final class_2940<Integer> FROST_COUNTER = class_2945.method_12791(Snuffle.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> DATA_HAIRSTYLE_ID = class_2945.method_12791(Snuffle.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DATA_FLUFF = class_2945.method_12791(Snuffle.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_FROSTY = class_2945.method_12791(Snuffle.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_LICKING = class_2945.method_12791(Snuffle.class, (class_2941)class_2943.field_13323);
    private int fluffGrowTime = 18000 + this.method_59922().method_43048(6000);

    public Snuffle(class_1299<Snuffle> snuffle, class_1937 world) {
        super(snuffle, world);
    }

    public static class_5132.class_5133 createSnuffleAttributes() {
        return class_1429.method_61457().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23721, 2.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new SnuffleClimbOnTopOfPowderSnowGoal((class_1308)this, this.method_37908()));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.5));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new SnuffleTemptGoal(1.1, class_1856.method_8106((class_6885)((class_6885)class_7923.field_41178.method_46733(SnufflesItemTags.SNUFFLE_FOOD).orElseThrow())), false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)new FrostGoal());
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.6f * this.method_5751()), (double)(this.method_17681() * 0.4f));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(FROST_COUNTER, (Object)0);
        builder.method_56912(DATA_HAIRSTYLE_ID, (Object)0);
        builder.method_56912(DATA_FLUFF, (Object)false);
        builder.method_56912(DATA_FROSTY, (Object)false);
        builder.method_56912(IS_LICKING, (Object)false);
    }

    public void method_5652(class_11372 compound) {
        super.method_5652(compound);
        compound.method_71465("Hairstyle", this.getHairstyleId());
        compound.method_71472("HasFluff", this.hasFluff());
        compound.method_71472("Frosty", this.isFrosty());
        compound.method_71465("FluffGrowTime", this.fluffGrowTime);
    }

    public void method_5749(class_11368 compound) {
        super.method_5749(compound);
        this.setHairstyleId(compound.method_71424("Hairstyle", 0));
        this.setFluff(compound.method_71433("HasFluff", false));
        this.setFrosty(compound.method_71433("Frosty", false));
        this.fluffGrowTime = compound.method_71424("FluffGrowTime", 0);
    }

    public void setFrostCounter(int counter) {
        this.field_6011.method_12778(FROST_COUNTER, (Object)counter);
    }

    public int getFrostCounter() {
        return (Integer)this.field_6011.method_12789(FROST_COUNTER);
    }

    public boolean isFrosting() {
        return this.getFrostCounter() > 0;
    }

    public void setHairstyleId(int id) {
        this.field_6011.method_12778(DATA_HAIRSTYLE_ID, (Object)id);
    }

    public int getHairstyleId() {
        return class_3532.method_15340((int)((Integer)this.field_6011.method_12789(DATA_HAIRSTYLE_ID)), (int)0, (int)3);
    }

    public Hairstyle getHairstyle() {
        return Hairstyle.getHairstyleById(this.getHairstyleId());
    }

    public void setFluff(boolean hasFluff) {
        this.field_6011.method_12778(DATA_FLUFF, (Object)hasFluff);
    }

    public boolean hasFluff() {
        return (Boolean)this.field_6011.method_12789(DATA_FLUFF);
    }

    public void setFrosty(boolean isFrosty) {
        this.field_6011.method_12778(DATA_FROSTY, (Object)isFrosty);
    }

    public boolean isFrosty() {
        return (Boolean)this.field_6011.method_12789(DATA_FROSTY);
    }

    public void setLicking(boolean isLicking) {
        this.field_6011.method_12778(IS_LICKING, (Object)isLicking);
    }

    public boolean isLicking() {
        return (Boolean)this.field_6011.method_12789(IS_LICKING);
    }

    public void method_5773() {
        super.method_5773();
        if (this.isFrosty()) {
            if (this.method_5809()) {
                this.method_5646();
                this.setFrosty(false);
                this.method_36975();
            }
            if ((this.field_6038 != this.method_23317() || this.field_5971 != this.method_23318() || this.field_5989 != this.method_23321()) && this.method_59922().method_43056()) {
                this.method_37908().method_8406((class_2394)SnufflesParticleTypes.SNOWFLAKE, this.method_23322(0.4), this.method_23319(), this.method_23325(0.4), 0.0, 0.0, 0.0);
            }
        }
        if (!this.hasFluff() && !this.method_6109()) {
            if (this.fluffGrowTime > 0) {
                --this.fluffGrowTime;
            } else {
                this.setFluff(true);
            }
        }
    }

    private boolean isSnowingAt(class_1937 world, class_2338 pos) {
        if (!this.method_37908().method_8419()) {
            return false;
        }
        if (!this.method_37908().method_8311(pos)) {
            return false;
        }
        if (this.method_37908().method_8598(class_2902.class_2903.field_13197, pos).method_10264() > pos.method_10264()) {
            return false;
        }
        return ((class_1959)this.method_37908().method_23753(pos).comp_349()).method_33599(pos, world.method_8615());
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31574(class_1802.field_8777)) {
            if (!this.method_37908().method_8608()) {
                this.method_6475(player, hand, stack);
                this.setHairstyleId((this.getHairstyleId() + 1) % 4);
                this.method_5783(SnufflesSoundEvents.SNUFFLE_STYLE, 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
            }
            return class_1269.field_5812;
        }
        if (stack.method_31574(class_1802.field_8135) && this.isFrosty()) {
            if (!this.method_37908().method_8608()) {
                this.setFrosty(false);
                this.method_6475(player, hand, stack);
                this.method_5783(SnufflesSoundEvents.SNUFFLE_THAW, 0.7f, 1.6f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.4f);
            }
            return class_1269.field_5812;
        }
        if (stack.method_31573(ConventionalItemTags.SHEAR_TOOLS)) {
            if (!this.method_37908().method_8608() && this.method_27072()) {
                this.method_6636((class_3218)this.method_37908(), class_3419.field_15248, stack);
                this.method_32875((class_6880)class_5712.field_28730, (class_1297)player);
                stack.method_7970(1, (class_1309)player, Snuffle.method_56079((class_1268)hand));
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        return super.method_5992(player, hand);
    }

    protected void method_6475(class_1657 player, class_1268 hand, class_1799 stack) {
        if (this.method_6481(stack)) {
            this.method_5783(SnufflesSoundEvents.SNUFFLE_EAT, 1.0f, 1.0f);
        }
        super.method_6475(player, hand, stack);
    }

    protected class_3414 method_5994() {
        return SnufflesSoundEvents.SNUFFLE_AMBIENT;
    }

    protected class_3414 method_6002() {
        return SnufflesSoundEvents.SNUFFLE_DEATH;
    }

    protected class_3414 method_6011(class_1282 source) {
        return SnufflesSoundEvents.SNUFFLE_HURT;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(SnufflesSoundEvents.SNUFFLE_STEP, 0.15f, 1.0f);
    }

    public void method_5711(byte id) {
        if (id == 10) {
            for (int i = 0; i < 4; ++i) {
                this.method_37908().method_8406((class_2394)SnufflesParticleTypes.SNOWFLAKE, this.method_23322(0.8), this.method_23320(), this.method_23325(0.8), 0.0, 0.1, 0.0);
            }
        } else {
            super.method_5711(id);
        }
    }

    public void method_6636(class_3218 world, class_3419 shearedSoundCategory, class_1799 shears) {
        if (this.method_37908().method_8608()) {
            return;
        }
        this.method_37908().method_43129(null, (class_1297)this, SnufflesSoundEvents.SNUFFLE_SHEAR, shearedSoundCategory, 1.0f, 1.0f);
        this.setFluff(false);
        this.fluffGrowTime = 18000 + this.method_59922().method_43048(6000);
        class_1542 itemEntity = this.method_5699((class_3218)this.method_37908(), new class_1799((class_1935)(this.isFrosty() ? SnufflesBlocks.FROSTY_FLUFF : SnufflesBlocks.SNUFFLE_FLUFF)), 1.0f);
        if (itemEntity != null) {
            itemEntity.method_18799(itemEntity.method_18798().method_1031((double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f), (double)(this.field_5974.method_43057() * 0.05f), (double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f)));
        }
    }

    public boolean method_27072() {
        return this.method_5805() && !this.method_6109() && this.hasFluff();
    }

    public static boolean checkSnuffleSpawnRules(class_1299<Snuffle> snuffle, class_1936 world, class_3730 spawnType, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(SnufflesBlockTags.SNUFFLES_SPAWNABLE_ON) && Snuffle.method_39448((class_1920)world, (class_2338)pos);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnType, @Nullable class_1315 groupData) {
        boolean frosty = ((class_1959)this.method_37908().method_23753(this.method_24515()).comp_349()).method_33599(this.method_24515(), world.method_8615());
        if (groupData instanceof SnuffleGroupData) {
            frosty = ((SnuffleGroupData)((Object)groupData)).frosty;
        } else {
            groupData = new SnuffleGroupData(frosty);
        }
        SnuffleGroupData snuffleGroupData = (SnuffleGroupData)((Object)groupData);
        if (snuffleGroupData.method_22432() > 0 && this.field_5974.method_43057() <= snuffleGroupData.method_22437()) {
            this.method_5614(-24000);
        } else {
            this.setFluff(true);
        }
        this.setFrosty(frosty);
        return super.method_5943(world, difficulty, spawnType, groupData);
    }

    @Nullable
    public Snuffle createChild(class_3218 world, class_1296 entity) {
        return (Snuffle)SnufflesEntityTypes.SNUFFLE.method_5883((class_1937)world, class_3730.field_16466);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(SnufflesItemTags.SNUFFLE_FOOD);
    }

    public void method_6078(class_1282 source) {
        this.setFrostCounter(0);
        super.method_6078(source);
    }

    class SnuffleClimbOnTopOfPowderSnowGoal
    extends class_6868 {
        public SnuffleClimbOnTopOfPowderSnowGoal(class_1308 mob, class_1937 world) {
            super(mob, world);
        }

        public boolean method_6264() {
            boolean flag;
            boolean bl = flag = Snuffle.this.field_28628 || Snuffle.this.field_27857;
            if (flag && Snuffle.this.method_5864().method_20210(class_3483.field_27855)) {
                class_2338 blockpos = Snuffle.this.method_24515().method_10084();
                class_2680 blockstate = Snuffle.this.method_37908().method_8320(blockpos);
                return blockstate.method_27852(class_2246.field_27879) || blockstate.method_26220((class_1922)Snuffle.this.method_37908(), blockpos) == class_259.method_1073() && Snuffle.this.isFrosty();
            }
            return false;
        }
    }

    class SnuffleTemptGoal
    extends class_1391 {
        public SnuffleTemptGoal(double speedModifier, class_1856 items, boolean canScare) {
            super((class_1314)Snuffle.this, speedModifier, (Predicate)items, canScare);
        }

        public void method_6269() {
            super.method_6269();
            Snuffle.this.setLicking(true);
        }

        public void method_6270() {
            super.method_6270();
            Snuffle.this.setLicking(false);
        }
    }

    class FrostGoal
    extends class_1352 {
        private static final int WAIT_TIME_BEFORE_FROST = FrostGoal.method_38848((int)140);
        private int countdown;

        public FrostGoal() {
            this.countdown = Snuffle.this.field_5974.method_43048(WAIT_TIME_BEFORE_FROST);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
        }

        public boolean method_6264() {
            return Snuffle.this.field_6212 == 0.0f && Snuffle.this.field_6227 == 0.0f && Snuffle.this.field_6250 == 0.0f && this.canFrost();
        }

        public boolean method_6266() {
            return Snuffle.this.isFrosting() && this.canFrost();
        }

        private boolean canFrost() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            class_1937 world = Snuffle.this.method_37908();
            class_2338 pos = Snuffle.this.method_24515();
            return !Snuffle.this.isFrosty() && (Snuffle.this.isSnowingAt(world, pos) || Snuffle.this.method_37908().method_8320(pos).method_27852(class_2246.field_27879));
        }

        public void method_6268() {
            Snuffle.this.setFrostCounter(Math.max(0, Snuffle.this.getFrostCounter() - 1));
            if (Snuffle.this.getFrostCounter() % this.method_38847(4) == 0) {
                Snuffle.this.method_5783(SnufflesSoundEvents.SNUFFLE_SHAKE, 1.0f, (Snuffle.this.field_5974.method_43057() - Snuffle.this.field_5974.method_43057()) * 0.2f + 1.0f);
                Snuffle.this.setFrosty(Snuffle.this.getFrostCounter() == this.method_38847(4));
                Snuffle.this.method_37908().method_8421((class_1297)Snuffle.this, (byte)10);
            }
        }

        public void method_6269() {
            Snuffle.this.setFrostCounter(this.method_38847(40));
            Snuffle.this.method_32876((class_6880)class_5712.field_45148);
            Snuffle.this.method_5942().method_6340();
        }

        public void method_6270() {
            Snuffle.this.setFrostCounter(0);
            this.countdown = Snuffle.this.field_5974.method_43048(WAIT_TIME_BEFORE_FROST);
        }
    }

    public static enum Hairstyle {
        DEFAULT,
        SHEEPDOG,
        PORO,
        HORSESHOE;

        private static final Hairstyle[] HAIRSTYLES;

        public static Hairstyle getHairstyleById(int id) {
            return HAIRSTYLES[id];
        }

        static {
            HAIRSTYLES = Hairstyle.values();
        }
    }

    public static class SnuffleGroupData
    extends class_1296.class_4697 {
        public final boolean frosty;

        public SnuffleGroupData(boolean frosty) {
            super(false);
            this.frosty = frosty;
        }
    }
}

