/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.core.networking.packets;

import com.deriys.divinerelics.items.Motosignir;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class MotosignirParticleS2CPacket {
    private final double playerX;
    private final double playerY;
    private final double playerZ;
    private final double viewVectorX;
    private final double viewVectorZ;

    public MotosignirParticleS2CPacket(double playerX, double playerY, double playerZ, double viewVectorX, double viewVectorZ) {
        this.playerX = playerX;
        this.playerY = playerY;
        this.playerZ = playerZ;
        this.viewVectorX = viewVectorX;
        this.viewVectorZ = viewVectorZ;
    }

    public MotosignirParticleS2CPacket(FriendlyByteBuf buf) {
        this.playerX = buf.readDouble();
        this.playerY = buf.readDouble();
        this.playerZ = buf.readDouble();
        this.viewVectorX = buf.readDouble();
        this.viewVectorZ = buf.readDouble();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeDouble(this.playerX);
        buf.writeDouble(this.playerY);
        buf.writeDouble(this.playerZ);
        buf.writeDouble(this.viewVectorX);
        buf.writeDouble(this.viewVectorZ);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            if (level != null) {
                Motosignir.addSoundWaveParticles((Level)level, this.playerX, this.playerY, this.playerZ, this.viewVectorX, this.viewVectorZ);
            }
        });
        return true;
    }
}

