/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.core.networking.packets;

import com.deriys.divinerelics.capabilities.stuck_spears.StuckSpear;
import com.deriys.divinerelics.capabilities.stuck_spears.StuckSpearsProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class StuckSpearsS2CPacket {
    private final int entityId;
    private final List<StuckSpear> stuckSpears;

    public StuckSpearsS2CPacket(int entityId, List<StuckSpear> stuckSpears) {
        this.entityId = entityId;
        this.stuckSpears = stuckSpears;
    }

    public StuckSpearsS2CPacket(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        int size = buf.readInt();
        this.stuckSpears = new ArrayList<StuckSpear>();
        for (int i = 0; i < size; ++i) {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            float rotation = buf.readFloat();
            boolean isFront = buf.readBoolean();
            this.stuckSpears.add(new StuckSpear(x, y, z, rotation, isFront));
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.stuckSpears.size());
        for (StuckSpear stuckSpear : this.stuckSpears) {
            buf.writeDouble(stuckSpear.x);
            buf.writeDouble(stuckSpear.y);
            buf.writeDouble(stuckSpear.z);
            buf.writeFloat(stuckSpear.rotation);
            buf.writeBoolean(stuckSpear.isFront);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            if (level != null && (entity = level.m_6815_(this.entityId)) instanceof LivingEntity) {
                entity.getCapability(StuckSpearsProvider.STUCK_SPEARS).ifPresent(cap -> cap.setSpears(this.stuckSpears));
            }
        });
        return true;
    }
}

