/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.effects;

import com.deriys.divinerelics.util.custom.TPData;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class BifrostProtection
extends MobEffect {
    public static final Random RAND = new Random();
    public static final double VECTOR_ANGLE_CONSTANT = 3.9269908169872414;

    public BifrostProtection(MobEffectCategory mobEffectCategory, int color) {
        super(mobEffectCategory, color);
    }

    public void m_6742_(LivingEntity livingEntity, int pAmplifier) {
        super.m_6742_(livingEntity, pAmplifier);
    }

    public static Vec2 findNormVec(Vec2 vector) {
        float x = vector.f_82470_;
        float z = vector.f_82471_;
        float zn = (float)((double)x / Math.sqrt(x * x + z * z));
        float xn = -z * zn / x;
        return new Vec2(xn, zn);
    }

    public static Vec2 findNormVec(Vec3 vector) {
        return BifrostProtection.findNormVec(new Vec2((float)vector.f_82479_, (float)vector.f_82480_));
    }

    public static Vec3 rotateVector(Vec2 normVector, double vectorAngle) {
        double baseAngle = Math.atan2(normVector.f_82471_, normVector.f_82470_);
        double angle = baseAngle + vectorAngle;
        return new Vec3(-Math.cos(angle), 0.0, -Math.sin(angle));
    }

    public static Vec3 rotateVector(Vec2 normVector, double vectorAngle, double length) {
        double baseAngle = Math.atan2(normVector.f_82471_, normVector.f_82470_);
        double angle = baseAngle + vectorAngle;
        return new Vec3(-Math.cos(angle), 0.0, -Math.sin(angle)).m_82490_(length);
    }

    public static Vec3 getTPVector(Level level, Vec2 normVector, Vec3 entityPos, double scale) {
        for (int i = 0; i < 5; ++i) {
            double vectorAngle = (double)RAND.nextFloat() * 3.9269908169872414;
            Vec3 vector = BifrostProtection.rotateVector(normVector, vectorAngle, scale);
            Vec3 tpVector = entityPos.m_82549_(vector);
            TPData isSafe = BifrostProtection.isSafeTP(level, tpVector);
            if (!isSafe.getStatus()) continue;
            return tpVector.m_82549_(new Vec3(0.0, (double)isSafe.getOffset(), 0.0));
        }
        BlockPos pos = new BlockPos(entityPos);
        return new Vec3((double)pos.m_123341_() + (double)RAND.nextFloat() * 0.4 + 0.3, entityPos.f_82480_, (double)pos.m_123343_() + (double)RAND.nextFloat() * 0.4 + 0.3);
    }

    public static TPData isSafeTP(Level level, Vec3 tpVector) {
        BlockPos middle = new BlockPos(tpVector);
        BlockPos ground = middle.m_7495_();
        BlockPos below = ground.m_7495_();
        BlockPos above = middle.m_7494_();
        BlockPos above1 = above.m_7494_();
        boolean isMiddleEmpty = BifrostProtection.isCollEmpty(level, level.m_8055_(middle), middle);
        boolean isAboveEmpty = BifrostProtection.isCollEmpty(level, level.m_8055_(above), above);
        boolean isAbove1Empty = BifrostProtection.isCollEmpty(level, level.m_8055_(above1), above1);
        boolean isGroundEmpty = BifrostProtection.isCollEmpty(level, level.m_8055_(ground), ground);
        boolean isBelowEmpty = BifrostProtection.isCollEmpty(level, level.m_8055_(below), below);
        if (isMiddleEmpty && isAboveEmpty) {
            if (!isGroundEmpty) {
                return new TPData(0, true);
            }
            if (!isBelowEmpty) {
                return new TPData(-1, true);
            }
        } else if (isAboveEmpty && isAbove1Empty && level.m_8055_(middle).m_60734_() != Blocks.f_50083_) {
            return new TPData(1, true);
        }
        return new TPData(0, false);
    }

    public static boolean isCollEmpty(Level level, BlockState blockState, BlockPos blockPos) {
        return blockState.m_60812_((BlockGetter)level, blockPos).m_83281_() && blockState.m_60734_() != Blocks.f_50083_;
    }

    public boolean m_6584_(int p_19455_, int p_19456_) {
        return true;
    }
}

