/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.entities.ai.thor;

import com.deriys.divinerelics.config.DivineRelicsCommonConfig;
import com.deriys.divinerelics.entities.ai.thor.ThorAttackState;
import com.deriys.divinerelics.entities.entity.ThorEntity;
import com.deriys.divinerelics.entities.entity.ThrownMjolnir;
import com.deriys.divinerelics.init.DRItems;
import com.deriys.divinerelics.init.DRSounds;
import com.deriys.divinerelics.items.DraupnirSpear;
import com.deriys.divinerelics.items.Motosignir;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ThorAttackGoal
extends MeleeAttackGoal {
    private final ThorEntity entity;
    private int attackDelay = -1;
    private int ticksUntilNextAttack = -1;
    private boolean shouldCountTillNextAttack = false;
    private ThorAttackState lastAttack = ThorAttackState.NONE;
    public static float CLAP_ATTACK_DAMAGE = ((Float)DivineRelicsCommonConfig.THOR_CLAP_DAMAGE.get()).floatValue();
    public static float CLAP_ATTACK_FORCE = ((Float)DivineRelicsCommonConfig.THOR_CLAP_FORCE.get()).floatValue();
    public static float CLAP_ATTACK_RADUIS = ((Float)DivineRelicsCommonConfig.THOR_CLAP_RADIUS.get()).floatValue();
    public static float GROUND_ATTACK_DAMAGE = ((Float)DivineRelicsCommonConfig.THOR_GROUND_DAMAGE.get()).floatValue();
    public static float GROUND_ATTACK_FORCE = ((Float)DivineRelicsCommonConfig.THOR_GROUND_FORCE.get()).floatValue();
    public static float GROUND_ATTACK_RADUIS = ((Float)DivineRelicsCommonConfig.THOR_GROUND_RADIUS.get()).floatValue();

    public ThorAttackGoal(PathfinderMob pathfinderMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super(pathfinderMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.entity = (ThorEntity)pathfinderMob;
    }

    public void m_8056_() {
        super.m_8056_();
    }

    protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
        if (this.isEnemyWithinAttackDistance(pEnemy, pDistToEnemySqr)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation()) {
                this.entity.setAttacking(true);
                this.entity.playAttackSound(this.entity.getAttackState());
            }
            if (this.m_25564_()) {
                this.f_25540_.m_21563_().m_24946_(pEnemy.m_20185_(), pEnemy.m_20188_(), pEnemy.m_20189_());
                this.performAttack(pEnemy);
            }
        } else if (this.entity.getAttackState() != ThorAttackState.NONE) {
            this.entity.setAttackState(ThorAttackState.NONE);
        }
    }

    private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
        float attackRange = 2.8f;
        ThorEntity thor = this.entity;
        boolean isAttacking = thor.isAttacking();
        double distance = this.m_6639_(pEnemy) + (double)(attackRange * attackRange);
        if (pDistToEnemySqr <= distance) {
            if (!isAttacking && this.ticksUntilNextAttack <= 0) {
                ThorAttackState randAttack = ThorAttackState.genCloseState(thor, this.lastAttack);
                this.setNewAttackState(randAttack);
            }
            return true;
        }
        ThorAttackState attackState = thor.getAttackState();
        if (pDistToEnemySqr <= distance * 2.0 && (this.shouldClapAttack() || attackState == ThorAttackState.CLAP_ATTACK)) {
            if (!isAttacking && this.canClapAttack() && this.ticksUntilNextAttack <= 0) {
                this.setNewAttackState(ThorAttackState.CLAP_ATTACK);
            }
            return true;
        }
        if (pDistToEnemySqr <= distance * 5.0 && (this.shouldGroundAttack() || attackState == ThorAttackState.GROUND_ATTACK)) {
            if (!isAttacking && this.canGroundAttack() && this.ticksUntilNextAttack <= 0) {
                this.setNewAttackState(ThorAttackState.GROUND_ATTACK);
            }
            return true;
        }
        if (pDistToEnemySqr > distance * 5.0 && this.entity.canSeeTarget(pEnemy) && (this.shouldMjolnirThrow() || attackState == ThorAttackState.MJOLNIR_THROW)) {
            if (!isAttacking && !thor.waitsForMjolnir() && thor.thrownMjolnirUUID == null && this.ticksUntilNextAttack <= 0) {
                this.setNewAttackState(ThorAttackState.MJOLNIR_THROW);
            }
            return true;
        }
        return attackState == ThorAttackState.MJOLNIR_THROW && isAttacking;
    }

    private boolean shouldMjolnirThrow() {
        return DraupnirSpear.RAND.nextDouble() < 0.04;
    }

    private boolean shouldClapAttack() {
        return DraupnirSpear.RAND.nextDouble() < 0.078;
    }

    private boolean shouldGroundAttack() {
        return DraupnirSpear.RAND.nextDouble() < 0.04;
    }

    private boolean canGroundAttack() {
        return this.lastAttack != ThorAttackState.GROUND_ATTACK;
    }

    private boolean canClapAttack() {
        return this.lastAttack != ThorAttackState.CLAP_ATTACK;
    }

    private void setNewAttackState(ThorAttackState attackState) {
        this.lastAttack = attackState;
        this.entity.setAttackState(attackState);
        this.assignDelayTicks();
    }

    private void assignDelayTicks() {
        int attackTicks = ThorAttackState.getAttackStateTicks(this.entity.getAttackState());
        this.ticksUntilNextAttack = attackTicks * 2;
        this.attackDelay = attackTicks;
    }

    protected void m_25563_() {
        this.ticksUntilNextAttack = this.m_183277_(this.attackDelay * 2);
    }

    protected boolean m_25564_() {
        return this.ticksUntilNextAttack == this.attackDelay;
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack == this.attackDelay * 2;
    }

    protected int m_25565_() {
        return this.ticksUntilNextAttack;
    }

    protected void performAttack(LivingEntity pEnemy) {
        ThorAttackState attackState = this.entity.getAttackState();
        if (attackState != ThorAttackState.MJOLNIR_THROW) {
            if (attackState == ThorAttackState.LEG_ATTACK) {
                Motosignir.applyKnockBack(pEnemy, (Entity)this.entity, 1.8f);
            }
            this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
            this.f_25540_.m_7327_((Entity)pEnemy);
        } else {
            ThorEntity thor = this.entity;
            thor.setHasMjolnirInHands(false);
            thor.setWaitsForMjolnir(true);
            Level level = thor.f_19853_;
            ThrownMjolnir thrownMjolnir = new ThrownMjolnir(level, (LivingEntity)thor, new ItemStack((ItemLike)DRItems.MJOLNIR.get()));
            thrownMjolnir.shootMjolnirAtTarget((LivingEntity)thor, pEnemy);
            thrownMjolnir.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            thrownMjolnir.m_20242_(true);
            level.m_7967_((Entity)thrownMjolnir);
            thor.thrownMjolnirUUID = thrownMjolnir.m_20148_();
            level.m_5594_(null, thor.m_20097_(), (SoundEvent)DRSounds.MJOLNIR_THROWING.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
    }

    public void m_8037_() {
        super.m_8037_();
        ThorEntity thor = this.entity;
        ThorAttackState state = thor.getAttackState();
        if (this.performsAttack(thor, 24, ThorAttackState.CLAP_ATTACK)) {
            ThrownMjolnir.onHitLighnting(thor.f_19853_, (Entity)thor, thor.m_20097_(), (LivingEntity)thor, thor.thorDamageSource, CLAP_ATTACK_DAMAGE, CLAP_ATTACK_FORCE, CLAP_ATTACK_RADUIS);
        } else if (this.performsAttack(thor, 25, ThorAttackState.GROUND_ATTACK)) {
            ThrownMjolnir.onHitLighnting(thor.f_19853_, (Entity)thor, thor.m_20097_(), (LivingEntity)thor, thor.thorDamageSource, GROUND_ATTACK_DAMAGE, GROUND_ATTACK_FORCE, GROUND_ATTACK_RADUIS);
        }
        if (!thor.f_19853_.f_46443_ && this.shouldCountTillNextAttack && this.ticksUntilNextAttack > 0) {
            --this.ticksUntilNextAttack;
            if (this.ticksUntilNextAttack == 0) {
                thor.setAttacking(false);
                if (state == ThorAttackState.MJOLNIR_THROW) {
                    thor.setAttackState(ThorAttackState.NONE);
                }
            }
        }
    }

    private boolean performsAttack(ThorEntity thor, int x, ThorAttackState attackState) {
        ThorAttackState thorAttackState = thor.getAttackState();
        return !thor.f_19853_.f_46443_ && this.ticksUntilNextAttack == x && (thorAttackState == attackState || this.lastAttack == attackState && thorAttackState == ThorAttackState.NONE);
    }

    public void m_8041_() {
        this.entity.setAttacking(false);
        this.entity.setAttackState(ThorAttackState.NONE);
        super.m_8041_();
    }
}

