/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.entities.entity;

import com.deriys.divinerelics.config.DivineRelicsCommonConfig;
import com.deriys.divinerelics.entities.ai.hel_walker.HelWalkerAttackGoal;
import com.deriys.divinerelics.entities.entity.DraugrEntity;
import com.deriys.divinerelics.init.DRItems;
import com.deriys.divinerelics.init.DRSounds;
import com.deriys.divinerelics.items.DraupnirSpear;
import com.deriys.divinerelics.items.HeimdallGauntlet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class HelWalkerEntity
extends Monster
implements IAnimatable {
    private static final AttributeModifier SLOW_SPEED_MODIFIER = new AttributeModifier("SlowSpeed", -0.3, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AttributeModifier FAST_SPEED_MODIFIER = new AttributeModifier("FastSpeed", (double)((Float)DivineRelicsCommonConfig.HEL_WALKER_SPEED_MODIFIER.get()).floatValue(), AttributeModifier.Operation.MULTIPLY_BASE);
    public static final int FREEZING_TIME = (Integer)DivineRelicsCommonConfig.HEL_WALKER_FREEZING_TIME.get();
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(HelWalkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int attackingTicks = 0;
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private SoundEvent[] attackSounds = new SoundEvent[]{(SoundEvent)DRSounds.HEL_WALKER_ATTACK_1.get(), (SoundEvent)DRSounds.HEL_WALKER_ATTACK_2.get(), (SoundEvent)DRSounds.HEL_WALKER_ATTACK_3.get()};
    private SoundEvent[] ambientSounds = new SoundEvent[]{(SoundEvent)DRSounds.HEL_WALKER_AMBIENT_1.get(), (SoundEvent)DRSounds.HEL_WALKER_AMBIENT_2.get(), (SoundEvent)DRSounds.HEL_WALKER_AMBIENT_3.get(), (SoundEvent)DRSounds.HEL_WALKER_AMBIENT_4.get(), (SoundEvent)DRSounds.HEL_WALKER_AMBIENT_5.get(), (SoundEvent)DRSounds.HEL_WALKER_AMBIENT_6.get()};
    private SoundEvent[] hitSounds = new SoundEvent[]{(SoundEvent)DRSounds.HEL_WALKER_HIT_1.get(), (SoundEvent)DRSounds.HEL_WALKER_HIT_2.get(), (SoundEvent)DRSounds.HEL_WALKER_HIT_3.get(), (SoundEvent)DRSounds.HEL_WALKER_HIT_4.get(), (SoundEvent)DRSounds.HEL_WALKER_HIT_5.get(), (SoundEvent)DRSounds.HEL_WALKER_HIT_6.get()};

    public HelWalkerEntity(EntityType<? extends HelWalkerEntity> entityType, Level level) {
        super(entityType, level);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    public void m_8119_() {
        LivingEntity target;
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.attackingTicks > 0) {
            --this.attackingTicks;
        }
        DraugrEntity.setChasing((LivingEntity)this, FAST_SPEED_MODIFIER, SLOW_SPEED_MODIFIER, (target = this.m_5448_()) != null && target.m_6084_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(1, (Goal)new HelWalkerAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{HelWalkerEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, (double)((Float)DivineRelicsCommonConfig.HEL_WALKER_FOLLOW_RANGE.get()).floatValue()).m_22268_(Attributes.f_22276_, (double)((Float)DivineRelicsCommonConfig.HEL_WALKER_HP.get()).floatValue()).m_22268_(Attributes.f_22278_, (double)((Float)DivineRelicsCommonConfig.HEL_WALKER_KB_RESISTANCE.get()).floatValue()).m_22268_(Attributes.f_22279_, (double)0.22f).m_22268_(Attributes.f_22281_, (double)((Float)DivineRelicsCommonConfig.HEL_WALKER_DAMAGE.get()).floatValue()).m_22268_(Attributes.f_22284_, (double)((Float)DivineRelicsCommonConfig.HEL_WALKER_ARMOR.get()).floatValue()).m_22266_(Attributes.f_22287_);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isAttacking() && this.attackingTicks == 0) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.hel_walker.attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            this.attackingTicks = 30;
            return PlayState.CONTINUE;
        }
        if (this.attackingTicks == 0) {
            if (event.isMoving()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.hel_walker.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.hel_walker.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public SoundEvent getAttackSound() {
        return this.attackSounds[HeimdallGauntlet.RAND.nextInt(0, 3)];
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return this.hitSounds[HeimdallGauntlet.RAND.nextInt(0, 3)];
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.ambientSounds[HeimdallGauntlet.RAND.nextInt(0, 6)];
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12452_;
    }

    public float m_6100_() {
        return DraupnirSpear.getRandomPitch();
    }

    public void m_6667_(DamageSource damageSource) {
        if (HeimdallGauntlet.RAND.nextFloat() > 0.5f) {
            this.m_19983_(new ItemStack((ItemLike)DRItems.HACKSILVER.get(), HeimdallGauntlet.RAND.nextInt(0, 3)));
        }
        if (HeimdallGauntlet.RAND.nextFloat() < 0.02f) {
            this.m_19983_(new ItemStack((ItemLike)DRItems.HARMONY_MUSIC_DISK.get()));
        }
        super.m_6667_(damageSource);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static boolean canSpawn(EntityType<HelWalkerEntity> helWalkerEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return HelWalkerEntity.m_217057_(helWalkerEntityType, (LevelAccessor)serverLevelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource) && serverLevelAccessor.m_46791_() != Difficulty.PEACEFUL;
    }
}

