/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.entities.entity;

import com.deriys.divinerelics.config.DivineRelicsCommonConfig;
import com.deriys.divinerelics.init.DRDwarfs;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SindriEntity
extends Villager
implements IAnimatable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private long lastRestockTime = 0L;
    private static final int RESTOCK_INTERVAL = (Integer)DivineRelicsCommonConfig.BROK_AND_SINDRI_RESTOCK_TIME.get();

    public SindriEntity(EntityType<? extends Villager> p_35381_, Level p_35382_) {
        super(p_35381_, p_35382_);
        this.m_34375_(this.m_7141_().m_35565_((VillagerProfession)DRDwarfs.SINDRI.get()));
        this.lastRestockTime = this.f_19853_.m_46467_();
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_34375_(this.m_7141_().m_35565_((VillagerProfession)DRDwarfs.SINDRI.get()));
    }

    public void m_34375_(VillagerData villagerData) {
        if (villagerData.m_35571_() != DRDwarfs.SINDRI.get()) {
            super.m_34375_(villagerData.m_35565_((VillagerProfession)DRDwarfs.SINDRI.get()));
        } else {
            super.m_34375_(villagerData);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            long currentTime = this.f_19853_.m_46467_();
            if (this.needsRestock() && currentTime - this.lastRestockTime >= (long)RESTOCK_INTERVAL) {
                this.restockTrades();
                this.lastRestockTime = currentTime;
            }
        }
    }

    public void m_8038_(ServerLevel p_35409_, LightningBolt p_35410_) {
    }

    private void restockTrades() {
        if (this.f_35261_ != null) {
            for (MerchantOffer offer : this.f_35261_) {
                offer.m_45372_();
            }
        }
    }

    private boolean needsRestock() {
        if (this.f_35261_ != null) {
            for (MerchantOffer offer : this.f_35261_) {
                if (!offer.m_45382_()) continue;
                return true;
            }
        }
        return false;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128356_("LastRestockTime", this.lastRestockTime);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("LastRestockTime")) {
            this.lastRestockTime = compound.m_128454_("LastRestockTime");
        }
    }

    public MerchantOffers m_6616_() {
        MerchantOffers offers = super.m_6616_();
        for (MerchantOffer offer : offers) {
            offer.m_45376_();
        }
        return offers;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{SindriEntity.class}));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public boolean m_6469_(DamageSource source, float p_21017_) {
        if (!(source.m_7639_() instanceof Player)) {
            super.m_6469_(source, p_21017_);
        }
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22277_, 5.0).m_22268_(Attributes.f_22276_, 1000.0).m_22268_(Attributes.f_22281_, 10.0);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sindri.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sindri.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource p_35498_) {
        return SoundEvents.f_11915_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    public SoundEvent m_7596_() {
        return null;
    }

    protected SoundEvent m_6068_(boolean p_35323_) {
        return null;
    }
}

