/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.entities.entity;

import com.deriys.divinerelics.capabilities.stuck_spears.StuckSpearsProvider;
import com.deriys.divinerelics.config.DivineRelicsCommonConfig;
import com.deriys.divinerelics.core.networking.DRMessages;
import com.deriys.divinerelics.core.networking.packets.SpearParticleS2CPacket;
import com.deriys.divinerelics.core.networking.packets.StuckSpearsS2CPacket;
import com.deriys.divinerelics.init.DREntitiyTypes;
import com.deriys.divinerelics.init.DRItems;
import com.deriys.divinerelics.init.DRSounds;
import com.deriys.divinerelics.items.DraupnirSpear;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class ThrownDraupnirSpear
extends AbstractArrow {
    private static final EntityDataAccessor<Boolean> ID_FOIL;
    private static final float SPEAR_DAMAGE;
    private double throwerX;
    private double throwerY;
    private double throwerZ;
    private ItemStack spearItem;
    private boolean dealtDamage;
    public boolean isOnGround = false;

    public static ThrownDraupnirSpear create(EntityType<? extends ThrownDraupnirSpear> type, Level level) {
        return new ThrownDraupnirSpear(type, level);
    }

    public ThrownDraupnirSpear(EntityType<? extends ThrownDraupnirSpear> type, Level level) {
        super(type, level);
        this.spearItem = new ItemStack((ItemLike)DRItems.DRAUPNIR_SPEAR.get());
    }

    public ThrownDraupnirSpear(Level level, LivingEntity livingEntity, ItemStack itemStack) {
        super((EntityType)DREntitiyTypes.THROWN_DRAUPNIR_SPEAR.get(), livingEntity, level);
        this.spearItem = itemStack;
        this.f_19804_.m_135381_(ID_FOIL, (Object)itemStack.m_41790_());
    }

    public void setThrowerPos(Vec3 throwerPos) {
        this.throwerX = throwerPos.f_82479_;
        this.throwerY = throwerPos.f_82480_;
        this.throwerZ = throwerPos.f_82481_;
    }

    public static void spawnSpearParticles(ClientLevel level, double x, double y, double z, double throwerX, double throwerY, double throwerZ, float pitch, float height) {
        BlockParticleOption particleOption = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50542_.m_49966_());
        double pitchRadians = Math.toRadians(pitch);
        Vec3 throwVec = new Vec3(throwerX - x, throwerY - y, throwerZ - z).m_82541_().m_82490_((double)height * Math.cos(pitchRadians));
        double offsetX = throwVec.f_82479_;
        double offsetY = (double)(-height) * Math.sin(pitchRadians);
        double offsetZ = throwVec.f_82481_;
        level.m_7106_((ParticleOptions)particleOption, x + offsetX + (Math.random() * 0.2 - 0.1), y + offsetY + (Math.random() * 0.2 - 0.1), z + offsetZ + (Math.random() * 0.2 - 0.1), 0.0, 0.0, 0.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
    }

    public void m_8119_() {
        if (this.f_36704_ > 0) {
            this.isOnGround = true;
        }
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        if (!this.f_19853_.f_46443_ && this.f_19797_ % 4 == 0) {
            SpearParticleS2CPacket packet = new SpearParticleS2CPacket(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.throwerX, this.throwerY, this.throwerZ, this.m_146909_(), 1.0f);
            DRMessages.sendToChunk(packet, this.f_19853_.m_46745_(this.m_20097_()));
        }
        super.m_8119_();
    }

    protected ItemStack m_7941_() {
        return this.spearItem.m_41777_();
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 p_37575_, Vec3 p_37576_) {
        return this.dealtDamage ? null : super.m_6351_(p_37575_, p_37576_);
    }

    public boolean m_6060_() {
        return false;
    }

    protected void m_5790_(EntityHitResult hitResult) {
        Entity owner;
        Entity hurtEntity = hitResult.m_82443_();
        float damage = SPEAR_DAMAGE;
        if (hurtEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)hurtEntity;
            damage += EnchantmentHelper.m_44833_((ItemStack)this.spearItem, (MobType)livingEntity.m_6336_());
        }
        DamageSource damageSource = DamageSource.m_19337_((Entity)this, (Entity)((owner = this.m_37282_()) == null ? this : owner));
        this.dealtDamage = true;
        SoundEvent soundEvent = (SoundEvent)DRSounds.DRAUPNIR_SPEAR_LANDING.get();
        if (hurtEntity.m_6469_(damageSource, damage)) {
            if (hurtEntity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (hurtEntity instanceof LivingEntity) {
                LivingEntity livingEntityHurt = (LivingEntity)hurtEntity;
                if (!(hurtEntity instanceof Player) || !((Player)hurtEntity).m_7500_()) {
                    Item item;
                    if (owner instanceof LivingEntity) {
                        EnchantmentHelper.m_44823_((LivingEntity)livingEntityHurt, (Entity)owner);
                        EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)livingEntityHurt);
                    }
                    if ((item = this.spearItem.m_41720_()) instanceof DraupnirSpear) {
                        DraupnirSpear draupnirSpear = (DraupnirSpear)item;
                        draupnirSpear.addThrownSpear(this.spearItem, hurtEntity.m_20148_());
                        hurtEntity.getCapability(StuckSpearsProvider.STUCK_SPEARS).ifPresent(cap -> {
                            Vec3 positionDifference = this.m_20182_().m_82546_(hurtEntity.m_20182_());
                            Vec2 bodyRotationVector = this.getBodyRotationVector((LivingEntity)hurtEntity);
                            Vec2 positionDifference2D = new Vec2((float)positionDifference.f_82479_, (float)positionDifference.f_82481_);
                            float angleBetweenVectors = (float)this.angleBetweenVectors(positionDifference2D, bodyRotationVector);
                            double hurtEntityWidth = hurtEntity.m_20205_();
                            double hurtEntityHeight = hurtEntity.m_20192_();
                            double xOffset = DraupnirSpear.RAND.nextDouble() * hurtEntityWidth * 0.6 - hurtEntityWidth * 0.3;
                            double yOffset = DraupnirSpear.RAND.nextDouble() * hurtEntityHeight * 0.6 + hurtEntityHeight * 0.3;
                            double zOffset = DraupnirSpear.RAND.nextDouble() * hurtEntityWidth * 0.3 - hurtEntityWidth * 0.15;
                            cap.addSpear(new Vec3(xOffset, yOffset, zOffset), DraupnirSpear.RAND.nextFloat() * 10.0f - 5.0f, angleBetweenVectors < 90.0f);
                            DRMessages.sendToAllPlayers(new StuckSpearsS2CPacket(hurtEntity.m_19879_(), cap.getSpears()));
                        });
                        if (!this.f_19853_.f_46443_) {
                            DraupnirSpear.sendExplosionPacket(this.f_19853_, hurtEntity.m_20185_(), this.m_20186_(), hurtEntity.m_20189_(), 1.0, 0.5, 10);
                        }
                    }
                    this.m_7761_(livingEntityHurt);
                    this.m_146870_();
                }
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.001, -0.01, -0.001));
        this.m_5496_(soundEvent, 2.0f, 1.0f);
    }

    public Vec2 getBodyRotationVector(LivingEntity entity) {
        float yaw = entity.f_20883_;
        float pitch = entity.m_146909_();
        float yawRad = (float)Math.toRadians(yaw);
        float pitchRad = (float)Math.toRadians(pitch);
        double x = -Math.sin(yawRad) * Math.cos(pitchRad);
        double z = Math.cos(yawRad) * Math.cos(pitchRad);
        return new Vec2((float)x, (float)z);
    }

    public double angleBetweenVectors(Vec2 vec1, Vec2 vec2) {
        return Math.toDegrees(Math.acos(vec1.m_165905_(vec2) / (vec1.m_165907_() * vec2.m_165907_())));
    }

    protected void m_8060_(BlockHitResult p_36755_) {
        super.m_8060_(p_36755_);
        this.m_36740_((SoundEvent)DRSounds.DRAUPNIR_SPEAR_LANDING.get());
    }

    public boolean isFoil() {
        return false;
    }

    protected boolean m_142470_(Player p_150196_) {
        return super.m_142470_(p_150196_) || this.m_36797_() && this.m_150171_((Entity)p_150196_) && p_150196_.m_150109_().m_36054_(this.m_7941_());
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)DRSounds.DRAUPNIR_SPEAR_LANDING.get();
    }

    public void m_6123_(Player p_37580_) {
        if (this.m_150171_((Entity)p_37580_) || this.m_37282_() == null) {
            super.m_6123_(p_37580_);
        }
    }

    public void m_7378_(CompoundTag p_37578_) {
        super.m_7378_(p_37578_);
        if (p_37578_.m_128425_("Spear", 10)) {
            this.spearItem = ItemStack.m_41712_((CompoundTag)p_37578_.m_128469_("Spear"));
        }
        this.dealtDamage = p_37578_.m_128471_("DealtDamage");
    }

    public void m_7380_(CompoundTag p_37582_) {
        super.m_7380_(p_37582_);
        p_37582_.m_128365_("Spear", (Tag)this.spearItem.m_41739_(new CompoundTag()));
        p_37582_.m_128379_("DealtDamage", this.dealtDamage);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6901_() {
        super.m_6901_();
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double p_37588_, double p_37589_, double p_37590_) {
        return true;
    }

    static {
        SPEAR_DAMAGE = ((Float)DivineRelicsCommonConfig.THROWN_DRAUPNIR_SPEAR_DAMAGE.get()).floatValue();
        ID_FOIL = SynchedEntityData.m_135353_(ThrownDraupnirSpear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }
}

