/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.entities.entity;

import com.deriys.divinerelics.capabilities.leviathan.LeviathanBindingProvider;
import com.deriys.divinerelics.config.DivineRelicsCommonConfig;
import com.deriys.divinerelics.init.DREntitiyTypes;
import com.deriys.divinerelics.init.DRItems;
import com.deriys.divinerelics.init.DRSounds;
import com.deriys.divinerelics.items.DraupnirSpear;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownLeviathanAxe
extends AbstractArrow {
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(ThrownLeviathanAxe.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOULD_RETURN = SynchedEntityData.m_135353_(ThrownLeviathanAxe.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack leviathanItem;
    public boolean dealtDamage;
    public boolean isOnGround = false;
    public int rotationDirection = 1;
    public int clientSideReturnTridentTickCount;
    public boolean shouldReturn = false;
    public boolean relaxed = false;
    public DamageSource damageSource = DamageSource.m_19337_((Entity)this, (Entity)(this.m_37282_() == null ? this : this.m_37282_()));
    public final int COOLDOWN = (Integer)DivineRelicsCommonConfig.LEVIATHAN_AXE_THROW_COOLDOWN.get();

    public ThrownLeviathanAxe(EntityType<? extends ThrownLeviathanAxe> entityType, Level level) {
        super(entityType, level);
        this.leviathanItem = new ItemStack((ItemLike)DRItems.LEVIATHAN_AXE.get());
    }

    public ThrownLeviathanAxe(Level p_37569_, LivingEntity p_37570_, ItemStack p_37571_) {
        super((EntityType)DREntitiyTypes.THROWN_LEVIATHAN.get(), p_37570_, p_37569_);
        this.leviathanItem = new ItemStack((ItemLike)DRItems.LEVIATHAN_AXE.get());
        this.leviathanItem = p_37571_.m_41777_();
        this.f_19804_.m_135381_(ID_FOIL, (Object)p_37571_.m_41790_());
        this.f_19804_.m_135381_(SHOULD_RETURN, (Object)this.shouldReturn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
        this.f_19804_.m_135372_(SHOULD_RETURN, (Object)false);
    }

    public void m_8119_() {
        Entity entity;
        boolean properReturnOwner;
        if (this.f_36704_ > 0) {
            this.isOnGround = true;
            this.dealtDamage = true;
        }
        if (!this.f_19853_.f_46443_ && (properReturnOwner = this.isAcceptibleReturnOwner()) && !this.isReturning() && this.m_20182_().m_82557_(this.m_37282_().m_20182_()) > 10000.0) {
            this.setReturning(true);
            this.relaxed = false;
            this.isOnGround = false;
        }
        if ((entity = this.m_37282_()) instanceof Player) {
            Player player = (Player)entity;
            if (!(this.isAcceptibleReturnOwner() || this.f_19853_.f_46443_ || this.relaxed || this.f_36705_ != AbstractArrow.Pickup.ALLOWED)) {
                this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                this.relax();
            } else if (!this.f_19853_.f_46443_ && player.m_6084_() && this.f_36705_ == AbstractArrow.Pickup.DISALLOWED) {
                this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            } else if (this.isReturning()) {
                this.relaxed = false;
                this.isOnGround = false;
                this.m_36790_(true);
                Vec3 vectorPM = player.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vectorPM.f_82480_ * 0.015 * 4.0, this.m_20189_());
                if (this.f_19853_.f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double fact = 0.15000000000000002;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vectorPM.m_82541_().m_82490_(fact)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.m_5496_((SoundEvent)DRSounds.LEVIATHAN_AXE_RETURN.get(), 15.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.m_8119_();
    }

    public boolean isReturning() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_RETURN);
    }

    public void setReturning(boolean returning) {
        this.f_19804_.m_135381_(SHOULD_RETURN, (Object)returning);
    }

    private boolean isAcceptibleReturnOwner() {
        Entity $$0 = this.m_37282_();
        if ($$0 != null && $$0.m_6084_()) {
            return !($$0 instanceof ServerPlayer) || !$$0.m_5833_();
        }
        return false;
    }

    private void relax() {
        this.m_20242_(false);
        this.m_36790_(false);
        this.m_20256_(this.m_20184_().m_82542_(0.001, 0.01, 0.001));
        this.setReturning(false);
        this.relaxed = true;
        this.clientSideReturnTridentTickCount = 0;
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    protected ItemStack m_7941_() {
        return this.leviathanItem.m_41777_();
    }

    public boolean isFoil() {
        return false;
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 p_37575_, Vec3 p_37576_) {
        return super.m_6351_(p_37575_, p_37576_);
    }

    protected void m_5790_(EntityHitResult hitResult) {
        Entity entity = hitResult.m_82443_();
        float damage = ((Float)DivineRelicsCommonConfig.LEVIATHAN_AXE_DAMAGE.get()).floatValue();
        if (entity instanceof LivingEntity) {
            LivingEntity hitEntity = (LivingEntity)entity;
            damage += EnchantmentHelper.m_44833_((ItemStack)this.leviathanItem, (MobType)hitEntity.m_6336_());
        }
        Entity owner = this.m_37282_();
        float volume = 1.0f;
        this.dealtDamage = true;
        this.rotationDirection *= -1;
        SoundEvent soundEvent = (SoundEvent)DRSounds.LEVIATHAN_AXE_IMPACT.get();
        if (entity.m_6469_(this.damageSource, damage)) {
            LivingEntity livingEntity;
            if (owner instanceof Player) {
                Player player = (Player)owner;
                player.m_36335_().m_41524_(this.leviathanItem.m_41720_(), this.COOLDOWN);
            }
            if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6084_()) {
                livingEntity.m_146917_(((Integer)DivineRelicsCommonConfig.THROWN_LEVIATHAN_FROZEN_TICKS_HIT.get()).intValue());
            }
            volume = 5.0f;
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntityHit = (LivingEntity)entity;
                if (owner instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntityHit, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)livingEntityHit);
                }
                this.m_7761_(livingEntityHit);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        this.m_5496_(soundEvent, volume, DraupnirSpear.RAND.nextFloat() * 0.15f + 0.925f);
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.m_36740_((SoundEvent)DRSounds.LEVIATHAN_AXE_IMPACT.get());
    }

    public boolean m_6060_() {
        return false;
    }

    protected boolean m_142470_(Player player) {
        if (super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.m_7941_())) {
            player.getCapability(LeviathanBindingProvider.LEVIATHAN_BINDING).ifPresent(binding -> binding.removeLeviathan(this.m_20148_().toString()));
            return true;
        }
        return false;
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)DRSounds.LEVIATHAN_AXE_IMPACT.get();
    }

    public void m_6123_(Player p_37580_) {
        if (this.m_150171_((Entity)p_37580_) || this.m_37282_() == null) {
            super.m_6123_(p_37580_);
        }
    }

    public void m_7378_(CompoundTag p_37578_) {
        super.m_7378_(p_37578_);
        if (p_37578_.m_128425_("Leviathan", 10)) {
            this.leviathanItem = ItemStack.m_41712_((CompoundTag)p_37578_.m_128469_("Leviathan"));
        }
        this.dealtDamage = p_37578_.m_128471_("DealtDamage");
        this.rotationDirection = p_37578_.m_128451_("RotationDirection");
    }

    public void m_7380_(CompoundTag p_37582_) {
        super.m_7380_(p_37582_);
        p_37582_.m_128365_("Leviathan", (Tag)this.leviathanItem.m_41739_(new CompoundTag()));
        p_37582_.m_128379_("DealtDamage", this.dealtDamage);
        this.rotationDirection = p_37582_.m_128451_("RotationDirection");
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED) {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double p_37588_, double p_37589_, double p_37590_) {
        return true;
    }

    public static ThrownLeviathanAxe create(EntityType<? extends ThrownLeviathanAxe> type, Level level) {
        return new ThrownLeviathanAxe(type, level);
    }
}

