/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.items;

import com.deriys.divinerelics.util.custom.StructureName;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DwarvenCompass
extends Item {
    public static final StructureName BROK_AND_SINDRI_SHOP = new StructureName("divinerelics:brok_and_sindri_shop", "Brok and Sindri Shop");
    public static final StructureName DWARVEN_MINES = new StructureName("divinerelics:dwarven_mines", "Ancient Dwarven Mines");

    public DwarvenCompass(Item.Properties properties) {
        super(properties);
    }

    public void setStructure(ItemStack stack, StructureName structure) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("nearestStructurePath", structure.getPath());
        tag.m_128359_("nearestStructureName", structure.getName());
    }

    public StructureName getStructure(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        String path = tag.m_128461_("nearestStructurePath");
        String name = tag.m_128461_("nearestStructureName");
        return new StructureName(path, name);
    }

    public void setStructureX(ItemStack stack, int x) {
        stack.m_41784_().m_128405_("nearestStructureX", x);
    }

    public int getStructureX(ItemStack stack) {
        return stack.m_41784_().m_128451_("nearestStructureX");
    }

    public void setStructureZ(ItemStack stack, int z) {
        stack.m_41784_().m_128405_("nearestStructureZ", z);
    }

    public int getStructureZ(ItemStack stack) {
        return stack.m_41784_().m_128451_("nearestStructureZ");
    }

    private StructureName changeStructure(StructureName structure) {
        return structure.equals(BROK_AND_SINDRI_SHOP) ? DWARVEN_MINES : BROK_AND_SINDRI_SHOP;
    }

    public boolean m_5812_(ItemStack p_40739_) {
        return false;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        boolean containsPos;
        if (!level.f_46443_ && !(containsPos = stack.m_41784_().m_128441_("nearestStructureX"))) {
            BlockPos shopPos = DwarvenCompass.findNearestStructure((ServerLevel)level, entity.m_20097_(), BROK_AND_SINDRI_SHOP.getPath());
            this.setStructure(stack, BROK_AND_SINDRI_SHOP);
            if (shopPos != null) {
                this.setStructureX(stack, shopPos.m_123341_());
                this.setStructureZ(stack, shopPos.m_123343_());
            }
        }
    }

    public static BlockPos findNearestStructure(ServerLevel level, BlockPos pos, String structure) {
        ResourceKey structureKey = ResourceKey.m_135785_((ResourceKey)Registry.f_235725_, (ResourceLocation)new ResourceLocation(structure));
        Holder structureHolder = level.m_5962_().m_175515_(Registry.f_235725_).m_206081_(structureKey);
        HolderSet.Direct holderset = HolderSet.m_205800_(Collections.singletonList(structureHolder));
        Pair result = level.m_7726_().m_8481_().m_223037_(level, (HolderSet)holderset, pos, 100, false);
        if (result != null) {
            return (BlockPos)result.getFirst();
        }
        return null;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.f_46443_) {
            StructureName structure;
            boolean empty = false;
            ItemStack stack = player.m_21120_(hand);
            BlockPos playerOnPos = player.m_20097_();
            if (player.m_6144_()) {
                structure = this.getStructure(stack);
                if (structure.getPath() != null) {
                    StructureName changedStructure = this.changeStructure(structure);
                    this.setStructure(stack, changedStructure);
                    player.m_213846_((Component)Component.m_237113_((String)("Looking for " + changedStructure.getName())));
                    BlockPos shopPos = DwarvenCompass.findNearestStructure((ServerLevel)level, playerOnPos, changedStructure.getPath());
                    if (shopPos != null) {
                        this.setStructureX(stack, shopPos.m_123341_());
                        this.setStructureZ(stack, shopPos.m_123343_());
                    } else {
                        player.m_213846_((Component)Component.m_237113_((String)"Could not find the structure.").m_130940_(ChatFormatting.DARK_RED));
                    }
                } else {
                    empty = true;
                }
            }
            if (!empty) {
                structure = this.getStructure(stack);
                int shopPosX = this.getStructureX(stack);
                int shopPosZ = this.getStructureZ(stack);
                player.m_213846_((Component)Component.m_237113_((String)("The nearest " + structure.getName() + " is " + Math.round(Math.sqrt(playerOnPos.m_123331_((Vec3i)new BlockPos(shopPosX, playerOnPos.m_123342_(), shopPosZ)))) + " blocks away.")));
            }
        }
        return super.m_7203_(level, player, hand);
    }
}

