/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.items;

import com.deriys.divinerelics.capabilities.mjolnir.MjolnirBindingProvider;
import com.deriys.divinerelics.config.DivineRelicsCommonConfig;
import com.deriys.divinerelics.entities.entity.ThrownMjolnir;
import com.deriys.divinerelics.event.DREvents;
import com.deriys.divinerelics.init.DRSounds;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Mjolnir
extends AxeItem {
    public static final int THROW_THRESHOLD_TIME = (Integer)DivineRelicsCommonConfig.MJOLNIR_THROW_THRESHOLD.get();
    public static final float BASE_DAMAGE = ((Float)DivineRelicsCommonConfig.MJOLNIR_DAMAGE.get()).floatValue();
    public static final float BASE_ATTACK_SPEED = ((Float)DivineRelicsCommonConfig.MJOLNIR_ATTACK_SPEED.get()).floatValue();
    public static final float SHOOT_POWER = ((Float)DivineRelicsCommonConfig.MJOLNIR_SHOOT_POWER.get()).floatValue();
    private static final int RIPTIDE_COOLDOWN = (Integer)DivineRelicsCommonConfig.MJOLNIR_RIPTIDE_COOLDOWN.get();
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public Mjolnir(Tier p_40521_, float p_40522_, float p_40523_, Item.Properties p_40524_) {
        super(p_40521_, p_40522_, p_40523_, p_40524_);
        ImmutableMultimap.Builder $$1 = ImmutableMultimap.builder();
        $$1.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)BASE_DAMAGE, AttributeModifier.Operation.ADDITION));
        $$1.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)BASE_ATTACK_SPEED, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = $$1.build();
    }

    public boolean m_6777_(BlockState p_43409_, Level p_43410_, BlockPos p_43411_, Player p_43412_) {
        return !p_43412_.m_7500_();
    }

    public UseAnim m_6164_(ItemStack p_43417_) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack p_43419_) {
        return 72000;
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity livingEntity, int use_ticks) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int ticks = this.m_8105_(itemStack) - use_ticks;
            if (ticks >= THROW_THRESHOLD_TIME) {
                if (!player.m_6144_() && !level.f_46443_) {
                    ThrownMjolnir thrownMjolnir = new ThrownMjolnir(level, (LivingEntity)player, itemStack);
                    thrownMjolnir.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, SHOOT_POWER, 1.0f);
                    if (player.m_150110_().f_35937_) {
                        thrownMjolnir.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    thrownMjolnir.m_20242_(true);
                    level.m_7967_((Entity)thrownMjolnir);
                    player.getCapability(MjolnirBindingProvider.MJOLNIR_BINDING).ifPresent(binding -> binding.addMjolnir(thrownMjolnir.m_20148_().toString()));
                    level.m_5594_(null, player.m_20097_(), (SoundEvent)DRSounds.MJOLNIR_THROWING.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!player.m_150110_().f_35937_) {
                        player.m_150109_().m_36057_(itemStack);
                    }
                } else if (player.m_6144_() && !player.m_21255_()) {
                    player.m_36335_().m_41524_(itemStack.m_41720_(), RIPTIDE_COOLDOWN);
                    if (!this.isRiptideFlying(itemStack)) {
                        this.setRiptideFlying(itemStack, true);
                    }
                    float f7 = player.m_146908_();
                    float f = player.m_146909_();
                    float f1 = -Mth.m_14031_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f2 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
                    float f3 = Mth.m_14089_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f4 = Mth.m_14116_((float)(f1 * f1 + f2 * f2 + f3 * f3));
                    float f5 = 6.0f;
                    player.m_5997_((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
                    player.m_204079_(30);
                    if (player.m_20096_()) {
                        float f6 = 1.1999999f;
                        player.m_6478_(MoverType.SELF, new Vec3(0.0, (double)f6, 0.0));
                    }
                    level.m_6269_((Player)null, (Entity)player, (SoundEvent)DRSounds.MJOLNIR_RIPTIDE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int p_41407_, boolean p_41408_) {
        if (DREvents.ForgeEvents.getOwner(itemStack).isEmpty()) {
            DREvents.ForgeEvents.bindItemToEntity(entity, itemStack);
        }
        super.m_6883_(itemStack, level, entity, p_41407_, p_41408_);
    }

    public void setRiptideFlying(ItemStack mjolnir, boolean isFlying) {
        if (mjolnir != null) {
            CompoundTag nbt = mjolnir.m_41784_();
            nbt.m_128379_("RiptideFlying", isFlying);
        }
    }

    public boolean isRiptideFlying(ItemStack mjolnir) {
        if (mjolnir != null) {
            CompoundTag nbt = mjolnir.m_41784_();
            return nbt.m_128471_("RiptideFlying");
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public boolean m_7579_(ItemStack p_43390_, LivingEntity p_43391_, LivingEntity p_43392_) {
        return true;
    }

    public boolean m_6813_(ItemStack p_43399_, Level p_43400_, BlockState p_43401_, BlockPos p_43402_, LivingEntity p_43403_) {
        return true;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot p_43383_) {
        return p_43383_ == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(p_43383_);
    }

    public int m_6473_() {
        return 1;
    }

    public boolean m_5812_(ItemStack p_41453_) {
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            components.add((Component)Component.m_237113_((String)"The legendary hammer of the God of Thunder, forged by the Huldra brothers, is now at your possession. Be careful, for the hammer does not make you its original possessor."));
        } else {
            components.add((Component)Component.m_237113_((String)"Press SHIFT for more info").m_130940_(ChatFormatting.YELLOW));
            String ownerName = stack.m_41784_().m_128461_("OwnerNickname");
            if (!ownerName.isEmpty()) {
                components.add((Component)Component.m_237113_((String)""));
                components.add((Component)Component.m_237113_((String)("Loyal to: " + ownerName)));
            }
        }
    }
}

