/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.items;

import com.deriys.divinerelics.capabilities.teammates.TeammatesProvider;
import com.deriys.divinerelics.config.DivineRelicsCommonConfig;
import com.deriys.divinerelics.core.networking.DRMessages;
import com.deriys.divinerelics.core.networking.packets.MotosignirParticleS2CPacket;
import com.deriys.divinerelics.entities.entity.ThorEntity;
import com.deriys.divinerelics.entities.entity.ThrownDraupnirSpear;
import com.deriys.divinerelics.init.DREffects;
import com.deriys.divinerelics.init.DRSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Motosignir
extends Item {
    public static final MobEffect[] STUN_EFFECTS = new MobEffect[]{MobEffects.f_19604_, MobEffects.f_19597_, MobEffects.f_19613_};
    public static final int EFFECTS_DURATION = (Integer)DivineRelicsCommonConfig.MOTOSIGNIR_EFFECTS_DURATION.get();
    public static final int AMPLIFIER = 2;

    public Motosignir(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            components.add((Component)Component.m_237113_((String)"Sindri's tuning fork. Somehow it survived Ragnarok..."));
        } else {
            components.add((Component)Component.m_237113_((String)"Press SHIFT for more info").m_130940_(ChatFormatting.YELLOW));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        double playerX = player.m_20185_();
        double playerY = player.m_20186_();
        double playerZ = player.m_20189_();
        Vec3 viewVector = player.m_20154_().m_82541_();
        if (!level.m_5776_() && !player.m_6144_()) {
            this.releaseSoundWave(level, player, playerX, playerY, playerZ);
            int cooldown = (Integer)DivineRelicsCommonConfig.MOTOSIGNIR_COOLDOWN.get();
            if (hand == InteractionHand.MAIN_HAND) {
                player.m_36335_().m_41524_((Item)this, cooldown);
            } else {
                player.m_36335_().m_41524_((Item)this, cooldown * 2);
            }
            MotosignirParticleS2CPacket particlePacket = new MotosignirParticleS2CPacket(playerX, playerY, playerZ, viewVector.f_82479_, viewVector.f_82481_);
            DRMessages.sendToChunk(particlePacket, level.m_46745_(player.m_20183_()));
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public static void addSoundWaveParticles(Level level, double playerX, double playerY, double playerZ, double viewVectorX, double viewVectorZ) {
        int particles = 50;
        for (int i = 0; i < particles; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, playerX + viewVectorX, playerY + 1.0, playerZ + viewVectorZ, 0.0, 0.0, 0.0);
            for (int j = 0; j < particles; ++j) {
                double horizontalAngle = Math.PI * 2 * (double)i / (double)particles;
                double verticalAngle = Math.PI * (double)j / (double)particles;
                double xSpeed = Math.cos(horizontalAngle) * Math.sin(verticalAngle);
                double ySpeed = Math.cos(verticalAngle);
                double zSpeed = Math.sin(verticalAngle) * Math.sin(horizontalAngle);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, playerX, playerY + 1.0, playerZ, xSpeed, ySpeed, zSpeed);
            }
        }
    }

    private void releaseSoundWave(Level level, Player player, double playerX, double playerY, double playerZ) {
        level.m_5594_(null, player.m_20097_(), (SoundEvent)DRSounds.MOTOSIGNIR_SOUND_WAVE.get(), SoundSource.PLAYERS, 3.0f, 1.0f);
        float radius = ((Float)DivineRelicsCommonConfig.MOTOSIGNIR_RANGE.get()).floatValue();
        float damage = ((Float)DivineRelicsCommonConfig.MOTOSIGNIR_DAMAGE.get()).floatValue();
        float force = ((Float)DivineRelicsCommonConfig.MOTOSIGNIR_FORCE.get()).floatValue();
        List<LivingEntity> entitiesInRadius = Motosignir.getEntitiesInArea(level, playerX, playerY, playerZ, radius);
        Motosignir.hurtAndKnockbackEntites(entitiesInRadius, player, STUN_EFFECTS, damage, force, 2, EFFECTS_DURATION);
    }

    public static List<LivingEntity> getEntitiesInArea(Level level, double x, double y, double z, double radius) {
        AABB aabb = new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        return level.m_45976_(LivingEntity.class, aabb);
    }

    public static <T extends Entity> List<T> getEntitiesInAreaOfClass(Class<T> entityClass, Level level, double x, double y, double z, double radius) {
        AABB aabb = new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        return level.m_45976_(entityClass, aabb);
    }

    public static <T extends Entity> List<T> getEntitiesInAreaOfClass(Class<T> entityClass, Level level, Entity entity, double radius) {
        return Motosignir.getEntitiesInAreaOfClass(entityClass, level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius);
    }

    public static void hurtAndKnockbackEntites(List<LivingEntity> entities, LivingEntity owner, Entity attacker, DamageSource damageSource, float baseDamage, double force) {
        for (LivingEntity livingEntity : entities) {
            if (livingEntity == owner || TeammatesProvider.hasTeammate(owner, livingEntity)) continue;
            double entityX = livingEntity.m_20185_();
            double entityZ = livingEntity.m_20189_();
            double angle = Math.atan2(entityZ - attacker.m_20189_(), entityX - attacker.m_20185_());
            double ratioX = -Math.cos(angle);
            double ratioZ = -Math.sin(angle);
            float armorModifier = (float)livingEntity.m_21133_(Attributes.f_22284_) / 12.0f;
            float adjustedDamage = baseDamage + armorModifier;
            ItemStack weapon = owner.m_21205_();
            adjustedDamage += EnchantmentHelper.m_44833_((ItemStack)weapon, (MobType)livingEntity.m_6336_());
            float distanceToEnemy = (float)livingEntity.m_146892_().m_82546_(attacker.m_20182_()).m_82553_();
            float distanceFactor = 1.0f - (distanceToEnemy - 1.5f) / (distanceToEnemy + 6.5f);
            if (!livingEntity.m_21023_((MobEffect)DREffects.BIFROST_PROTECTION.get()) || damageSource.m_7639_() instanceof ThorEntity) {
                livingEntity.m_147240_(force, ratioX, ratioZ);
            }
            livingEntity.m_6469_(damageSource, Math.min(adjustedDamage, adjustedDamage * distanceFactor));
            EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)owner);
            EnchantmentHelper.m_44896_((LivingEntity)owner, (Entity)livingEntity);
            if (!(attacker instanceof ThrownDraupnirSpear)) continue;
            livingEntity.f_19802_ = 1;
        }
    }

    public static void hurtAndKnockbackEntites(List<LivingEntity> entities, Player player, MobEffect[] mobEffects, float baseDamage, double force, int amplifier, int duration) {
        for (LivingEntity livingEntity : entities) {
            if (livingEntity == player || livingEntity instanceof Player && ((Player)livingEntity).m_7500_() || TeammatesProvider.hasTeammate((LivingEntity)player, livingEntity)) continue;
            double entityX = livingEntity.m_20185_();
            double entityZ = livingEntity.m_20189_();
            double angle = Math.atan2(entityZ - player.m_20189_(), entityX - player.m_20185_());
            double ratioX = -Math.cos(angle);
            double ratioZ = -Math.sin(angle);
            float armorModifier = (float)livingEntity.m_21133_(Attributes.f_22284_) / 12.0f;
            float adjustedDamage = baseDamage + armorModifier;
            ItemStack weapon = player.m_21205_();
            DamageSource damageSource = DamageSource.m_19344_((Player)player);
            float distanceToEnemy = (float)livingEntity.m_20182_().m_82546_(player.m_20182_()).m_82553_();
            float distanceFactor = 1.0f - (distanceToEnemy - 1.5f) / (distanceToEnemy + 6.5f);
            livingEntity.m_6469_(damageSource, Math.min(adjustedDamage += EnchantmentHelper.m_44833_((ItemStack)weapon, (MobType)livingEntity.m_6336_()), adjustedDamage * distanceFactor));
            EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)player);
            EnchantmentHelper.m_44896_((LivingEntity)player, (Entity)livingEntity);
            if (livingEntity.m_21023_((MobEffect)DREffects.BIFROST_PROTECTION.get())) continue;
            livingEntity.m_147240_(force, ratioX, ratioZ);
            Motosignir.gainMobEffects(livingEntity, mobEffects, duration, amplifier);
        }
    }

    public static void applyKnockBack(LivingEntity livingEntity, Entity attacker, double force) {
        double entityX = livingEntity.m_20185_();
        double entityZ = livingEntity.m_20189_();
        double angle = Math.atan2(entityZ - attacker.m_20189_(), entityX - attacker.m_20185_());
        double ratioX = -Math.cos(angle);
        double ratioZ = -Math.sin(angle);
        Motosignir.applyKnockBack(livingEntity, force, ratioX, ratioZ);
    }

    public static void applyKnockBack(LivingEntity livingEntity, double force, double ratioX, double ratioZ) {
        if (!((force *= 1.0 - livingEntity.m_21133_(Attributes.f_22278_)) <= 0.0)) {
            livingEntity.f_19812_ = true;
            Vec3 vec3 = livingEntity.m_20184_();
            Vec3 vec31 = new Vec3(ratioX, 0.0, ratioZ).m_82541_().m_82490_(force);
            livingEntity.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, livingEntity.m_20096_() ? Math.min(0.4, vec3.f_82480_ / 2.0 + force) : vec3.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
        }
    }

    public static void gainMobEffects(LivingEntity livingEntity, MobEffect[] mobEffects, int effectsDuration, int amplifier) {
        for (MobEffect mobEffect : mobEffects) {
            livingEntity.m_7292_(new MobEffectInstance(mobEffect, effectsDuration, amplifier));
        }
    }
}

