/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.structures;

import com.deriys.divinerelics.config.DivineRelicsCommonConfig;
import com.deriys.divinerelics.init.DRStructures;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class NoWaterNearbyStructure
extends Structure {
    public static final Codec<NoWaterNearbyStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NoWaterNearbyStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, NoWaterNearbyStructure::new)).codec();
    public static final List<String> WATER_BIOMES = Arrays.asList("minecraft:river", "minecraft:frozen_river", "minecraft:beach", "minecraft:snowy_beach", "minecraft:stony_shore", "minecraft:swamp", "minecraft:ocean", "minecraft:cold_ocean", "minecraft:deep_cold_ocean", "minecraft:deep_frozen_ocean", "minecraft:frozen_ocean", "minecraft:warm_ocean", "minecraft:lukewarm_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:deep_ocean");
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public NoWaterNearbyStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    private static boolean extraSpawningChecks(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), 0, chunkPos.m_45605_());
        boolean isFarFromWater = true;
        if (((Boolean)DivineRelicsCommonConfig.NO_WATER_NEARBY_USE.get()).booleanValue()) {
            isFarFromWater = NoWaterNearbyStructure.isFarFromWaterBiomes(context, blockPos);
        }
        return context.f_226622_().m_223235_(chunkPos.m_45604_(), chunkPos.m_45605_(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, context.f_226629_(), context.f_226624_()) < 90 && isFarFromWater;
    }

    private static boolean isFarFromWaterBiomes(Structure.GenerationContext context, BlockPos pos) {
        Set biomes = context.f_226623_().m_183399_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), ((Integer)DivineRelicsCommonConfig.NO_WATER_NEARBY_DISTANCE.get()).intValue(), context.f_226624_().m_224579_());
        for (Holder biomeHolder : biomes) {
            Biome biome = (Biome)biomeHolder.m_203334_();
            System.out.println(BuiltinRegistries.f_123865_.m_7981_((Object)biome));
            ResourceLocation biomeName = context.f_226621_().m_175515_(Registry.f_122885_).m_7981_((Object)biome);
            if (biomeName == null || !WATER_BIOMES.contains(biomeName.toString())) continue;
            return false;
        }
        return true;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (!NoWaterNearbyStructure.extraSpawningChecks(context)) {
            return Optional.empty();
        }
        int startY = context.f_226622_().m_223235_(context.f_226628_().m_45604_(), context.f_226628_().m_45605_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        ChunkPos chunkPos = context.f_226628_();
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
        Optional structurePiecesGenerator = JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, Optional.empty(), (int)this.maxDistanceFromCenter);
        return structurePiecesGenerator;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)DRStructures.NO_WATER_NEARBY.get();
    }
}

