/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.libs.axapi.reflection;

import com.artillexstudios.axtrade.libs.axapi.libs.caffeine.caffeine.cache.Caffeine;
import com.artillexstudios.axtrade.libs.axapi.libs.caffeine.caffeine.cache.LoadingCache;
import com.artillexstudios.axtrade.libs.axapi.utils.logging.LogUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public enum ClassUtils {
    INSTANCE;

    private final LoadingCache<String, Class<?>> CLASS_CACHE = Caffeine.newBuilder().maximumSize(50L).build(name -> {
        try {
            return Class.forName(name, false, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (ClassNotFoundException exception) {
            return null;
        }
    });

    public boolean classExists(@NotNull String className) {
        return this.CLASS_CACHE.get((Object)className) != null;
    }

    public Class<?> getClass(String clazz) {
        try {
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException exception) {
            LogUtils.error("An unexpected error occurred while finding class {}!", clazz, exception);
            throw new RuntimeException(exception);
        }
    }

    public Class<?> getClassOrNull(String clazz) {
        try {
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException exception) {
            return null;
        }
    }

    public boolean isClass(Class<?> clazz, String other) {
        return this.CLASS_CACHE.get((Object)other) == clazz;
    }

    public boolean classEquals(Class<?> clazz, Class<?> other) {
        return clazz != null && clazz == other;
    }

    public <T> T create(Class<T> clazz, Object ... arguments) {
        Class[] classes = arguments.length == 0 ? new Class[]{} : (Class[])Arrays.stream(arguments).map(Object::getClass).toArray(Class[]::new);
        try {
            return clazz.getDeclaredConstructor(classes).newInstance(arguments);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            LogUtils.error("Failed to initialize class {} with arguments {}!", clazz.getName(), Arrays.toString(arguments));
            return null;
        }
    }

    public String debugClass(Class<?> clazz) {
        return this.debugClass(0, clazz);
    }

    private String debugClass(int indent, Class<?> clazz) {
        StringBuilder builder = new StringBuilder();
        builder.append("--- ").append(clazz.getName()).append(" ---").append(System.lineSeparator());
        builder.append("\t".repeat(indent)).append("Interface: ").append(clazz.isInterface()).append(System.lineSeparator());
        builder.append("\t".repeat(indent)).append("Record: ").append(clazz.isRecord()).append(System.lineSeparator());
        builder.append("\t".repeat(indent)).append("Sealed: ").append(clazz.isSealed()).append(System.lineSeparator());
        builder.append("\t".repeat(indent)).append("Member: ").append(clazz.isMemberClass()).append(System.lineSeparator());
        builder.append("\t".repeat(indent)).append("Array: ").append(clazz.isArray()).append(System.lineSeparator());
        builder.append("\t".repeat(indent)).append("Enum: ").append(clazz.isEnum()).append(System.lineSeparator());
        builder.append("\t".repeat(indent)).append("Hidden: ").append(clazz.isHidden()).append(System.lineSeparator());
        builder.append("\t".repeat(indent)).append("Implemented interfaces: ").append(String.join((CharSequence)", ", Arrays.stream(clazz.getInterfaces()).map(Class::getName).toList())).append(System.lineSeparator());
        builder.append("\t".repeat(indent)).append("Subclasses: ").append(System.lineSeparator());
        for (Class<?> clazz2 : clazz.getClasses()) {
            builder.append("\t".repeat(indent + 1)).append(this.debugClass(indent + 1, clazz2)).append(System.lineSeparator());
        }
        builder.append("\t".repeat(indent)).append("Fields: ").append(System.lineSeparator());
        for (AnnotatedElement annotatedElement : clazz.getDeclaredFields()) {
            builder.append("\t".repeat(indent + 1)).append("Name: ").append(((Field)annotatedElement).getName()).append(System.lineSeparator());
            builder.append("\t".repeat(indent + 1)).append("Modifiers: ").append(Modifier.toString(((Field)annotatedElement).getModifiers())).append(System.lineSeparator());
            builder.append("\t".repeat(indent + 1)).append("Type: ").append(((Field)annotatedElement).getType()).append(System.lineSeparator());
            builder.append("\t".repeat(indent + 1)).append("Generic type: ").append(((Field)annotatedElement).getGenericType()).append(System.lineSeparator());
            builder.append("\t".repeat(indent + 1)).append("Annotated type: ").append(((Field)annotatedElement).getAnnotatedType()).append(System.lineSeparator());
        }
        builder.append("\t".repeat(indent)).append("Methods: ").append(System.lineSeparator());
        for (AnnotatedElement annotatedElement : clazz.getDeclaredMethods()) {
            builder.append("\t".repeat(indent + 1)).append("Name: ").append(((Method)annotatedElement).getName()).append(System.lineSeparator());
            builder.append("\t".repeat(indent + 1)).append("Modifiers: ").append(Modifier.toString(((Method)annotatedElement).getModifiers())).append(System.lineSeparator());
            builder.append("\t".repeat(indent + 1)).append("Type: ").append(((Method)annotatedElement).getReturnType()).append(System.lineSeparator());
            builder.append("\t".repeat(indent + 1)).append("Generic type: ").append(((Method)annotatedElement).getGenericReturnType()).append(System.lineSeparator());
            builder.append("\t".repeat(indent + 1)).append("Annotated type: ").append(((Method)annotatedElement).getAnnotatedReturnType()).append(System.lineSeparator());
            builder.append("\t".repeat(indent + 1)).append("Parameter count: ").append(((Method)annotatedElement).getParameterCount()).append(System.lineSeparator());
            builder.append("\t".repeat(indent + 1)).append("Parameters: ").append(String.join((CharSequence)", ", Arrays.stream(((Method)annotatedElement).getParameterTypes()).map(Class::getName).toList())).append(System.lineSeparator());
        }
        Set<Class<?>> superClasses = this.superClasses(clazz);
        builder.append("\t".repeat(indent)).append("Super classes: ").append(System.lineSeparator());
        for (Class<?> superClass : superClasses) {
            builder.append("\t".repeat(indent + 1)).append(this.debugClass(indent + 1, superClass)).append(System.lineSeparator());
        }
        return builder.toString();
    }

    public Class<?>[] interfaces(Class<?> clazz) {
        return clazz.getInterfaces();
    }

    public Set<Class<?>> superClasses(Class<?> clazz) {
        return this.superClasses(clazz, false);
    }

    public Set<Class<?>> superClasses(Class<?> clazz, boolean self) {
        HashSet superClasses = new HashSet();
        if (self) {
            superClasses.add(clazz);
        }
        while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class) {
            superClasses.add(clazz);
        }
        return superClasses;
    }
}

