/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.trade;

import com.artillexstudios.axtrade.AxTrade;
import com.artillexstudios.axtrade.hooks.HookManager;
import com.artillexstudios.axtrade.hooks.currency.CurrencyHook;
import com.artillexstudios.axtrade.libs.axapi.gui.SignInput;
import com.artillexstudios.axtrade.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axtrade.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axtrade.libs.axapi.utils.Cooldown;
import com.artillexstudios.axtrade.libs.axapi.utils.StringUtils;
import com.artillexstudios.axtrade.libs.gui.builder.gui.StorageBuilder;
import com.artillexstudios.axtrade.libs.gui.guis.BaseGui;
import com.artillexstudios.axtrade.libs.gui.guis.Gui;
import com.artillexstudios.axtrade.libs.gui.guis.GuiItem;
import com.artillexstudios.axtrade.libs.gui.guis.StorageGui;
import com.artillexstudios.axtrade.safety.SafetyManager;
import com.artillexstudios.axtrade.trade.GuiFrame;
import com.artillexstudios.axtrade.trade.Trade;
import com.artillexstudios.axtrade.trade.TradePlayer;
import com.artillexstudios.axtrade.utils.BlacklistUtils;
import com.artillexstudios.axtrade.utils.NumberUtils;
import com.artillexstudios.axtrade.utils.ShulkerUtils;
import com.artillexstudios.axtrade.utils.TaxUtils;
import com.artillexstudios.axtrade.utils.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Keyed;
import org.bukkit.Tag;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TradeGui
extends GuiFrame {
    private static final Cooldown<Player> confirmCooldown = Cooldown.create();
    protected final Trade trade;
    private final TradePlayer player;
    protected final StorageGui gui;
    protected final List<Integer> slots = this.getSlots("own-slots");
    protected final List<Integer> otherSlots = this.getSlots("partner-slots");
    private String currentTitle = "";
    private boolean inSign = false;

    public TradeGui(@NotNull Trade trade, @NotNull TradePlayer player) {
        super(AxTrade.GUIS, player.getPlayer(), trade);
        this.trade = trade;
        this.player = player;
        this.gui = ((StorageBuilder)((StorageBuilder)((StorageBuilder)Gui.storage().rows(AxTrade.GUIS.getInt("rows", 6))).title((Component)Component.empty())).disableItemDrop()).create();
        this.setGui(this.gui);
        this.gui.setDefaultTopClickAction(this::handleClickTop);
        this.gui.setDragAction(this::handleDrag);
        this.gui.setPlayerInventoryAction(this::handleClickBottom);
        this.gui.setCloseGuiAction(this::handleClose);
        if (trade.isEnded()) {
            return;
        }
        this.update();
        this.gui.open((HumanEntity)player.getPlayer());
        this.updateTitle();
        this.opened = true;
    }

    public void update() {
        CurrencyHook currencyHook;
        String currencyStr;
        if (this.player.hasConfirmed()) {
            super.createItem("own.confirm-item.slot", "own.confirm-item.cancel", event -> {
                event.setCancelled(true);
                if (confirmCooldown.hasCooldown(this.player.getPlayer())) {
                    return;
                }
                confirmCooldown.addCooldown(this.player.getPlayer(), 50L);
                this.player.cancel();
                this.trade.update();
            }, Map.of(), AxTrade.CONFIG.getBoolean("static-accept-item-amount", true) ? 1 : this.player.getConfirmed());
        } else {
            super.createItem("own.confirm-item.slot", "own.confirm-item.accept", event -> {
                event.setCancelled(true);
                if (confirmCooldown.hasCooldown(this.player.getPlayer())) {
                    return;
                }
                confirmCooldown.addCooldown(this.player.getPlayer(), 50L);
                this.player.confirm();
            }, Map.of());
        }
        if (this.player.getOtherPlayer().hasConfirmed()) {
            super.createItem("partner.confirm-item.slot", "partner.confirm-item.cancel", event -> event.setCancelled(true), Map.of("%own-name%", this.player.getPlayer().getName(), "%partner-name%", this.player.getOtherPlayer().getPlayer().getName()), AxTrade.CONFIG.getBoolean("static-accept-item-amount", true) ? 1 : this.player.getOtherPlayer().getConfirmed());
        } else {
            super.createItem("partner.confirm-item.slot", "partner.confirm-item.accept", event -> event.setCancelled(true), Map.of("%own-name%", this.player.getPlayer().getName(), "%partner-name%", this.player.getOtherPlayer().getPlayer().getName()));
        }
        for (String currencyItem : AxTrade.GUIS.getSection("own").getRoutesAsStrings(false)) {
            currencyStr = AxTrade.GUIS.getString("own." + currencyItem + ".currency", null);
            if (currencyStr == null || (currencyHook = HookManager.getCurrencyHook(currencyStr)) == null) continue;
            super.createItem("own." + currencyItem, event -> this.handleCurrencyClick(currencyStr, (InventoryClickEvent)event), Map.of("%amount%", NumberUtils.formatNumber(this.player.getCurrency(currencyStr)), "%tax-amount%", NumberUtils.formatNumber(TaxUtils.getTotalAfterTax(this.player.getCurrency(currencyStr), currencyHook)), "%tax-percent%", NumberUtils.formatNumber(TaxUtils.getTaxPercent(currencyHook).doubleValue()), "%tax-fee%", NumberUtils.formatNumber(TaxUtils.getTotalTax(this.player.getCurrency(currencyStr), currencyHook))));
        }
        for (String currencyItem : AxTrade.GUIS.getSection("partner").getRoutesAsStrings(false)) {
            currencyStr = AxTrade.GUIS.getString("partner." + currencyItem + ".currency", null);
            if (currencyStr == null || (currencyHook = HookManager.getCurrencyHook(currencyStr)) == null) continue;
            super.createItem("partner." + currencyItem, event -> event.setCancelled(true), Map.of("%amount%", NumberUtils.formatNumber(this.player.getOtherPlayer().getCurrency(currencyStr)), "%tax-amount%", NumberUtils.formatNumber(TaxUtils.getTotalAfterTax(this.player.getOtherPlayer().getCurrency(currencyStr), currencyHook)), "%tax-percent%", NumberUtils.formatNumber(TaxUtils.getTaxPercent(currencyHook).doubleValue()), "%tax-fee%", NumberUtils.formatNumber(TaxUtils.getTotalTax(this.player.getOtherPlayer().getCurrency(currencyStr), currencyHook))));
        }
        Iterator<Object> iterator = this.otherSlots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            this.gui.removeItem(slot);
        }
        if (!this.opened) {
            return;
        }
        List<ItemStack> otherItems = this.player.getOtherPlayer().getTradeGui().getItems(true);
        int n = 0;
        for (int slot : this.otherSlots) {
            if (otherItems.get(n) != null) {
                this.gui.updateItem(slot, new GuiItem(otherItems.get(n), event -> event.setCancelled(true)));
            }
            ++n;
        }
    }

    private void handleClickTop(InventoryClickEvent event) {
        if (confirmCooldown.hasCooldown(this.player.getPlayer())) {
            event.setCancelled(true);
            return;
        }
        ItemStack it = this.getItem(event);
        if (BlacklistUtils.isBlacklisted(it)) {
            event.setCancelled(true);
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)this.player.getPlayer(), "trade.blacklisted-item", new TagResolver[0]);
            return;
        }
        if (event.getCurrentItem() == null && it != null && this.checkFull((Cancellable)event)) {
            return;
        }
        if (event.getCurrentItem() != null && event.getClick().isRightClick() && Tag.SHULKER_BOXES.isTagged((Keyed)event.getCurrentItem().getType())) {
            this.handleShulkerClick(event);
            return;
        }
        if (!this.slots.contains(event.getSlot())) {
            event.setCancelled(true);
            if (event.getCursor() == null) {
                return;
            }
            this.player.getPlayer().getInventory().addItem(new ItemStack[]{event.getCursor().clone()});
            event.getCursor().setAmount(0);
            return;
        }
        this.player.cancel();
        Scheduler.get().run(scheduledTask -> this.trade.update());
    }

    private void handleClickBottom(InventoryClickEvent event) {
        ItemStack it = this.getItem(event);
        if (BlacklistUtils.isBlacklisted(it)) {
            event.setCancelled(true);
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)this.player.getPlayer(), "trade.blacklisted-item", new TagResolver[0]);
            return;
        }
        if (event.getCurrentItem() != null) {
            if (this.checkFull((Cancellable)event)) {
                return;
            }
            if (event.isShiftClick() && event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY && !this.slots.contains(event.getView().getTopInventory().firstEmpty())) {
                event.setCancelled(true);
                for (int i : this.slots) {
                    if (this.gui.getInventory().getItem(i) != null) continue;
                    this.gui.getInventory().setItem(i, event.getCurrentItem().clone());
                    event.getCurrentItem().setAmount(0);
                    break;
                }
            }
        }
        this.player.cancel();
        Scheduler.get().run(scheduledTask -> this.trade.update());
    }

    private void handleDrag(InventoryDragEvent event) {
        boolean ownInv = true;
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int s = (Integer)iterator.next();
            if (s > 53) continue;
            ownInv = false;
            break;
        }
        Scheduler.get().run(scheduledTask -> this.trade.update());
        if (ownInv) {
            return;
        }
        if (!new HashSet<Integer>(this.slots).containsAll(event.getInventorySlots())) {
            event.setCancelled(true);
            return;
        }
        this.player.cancel();
    }

    private void handleClose(InventoryCloseEvent event) {
        if (this.inSign) {
            return;
        }
        this.trade.abort();
    }

    private boolean checkFull(Cancellable event) {
        int emptySlots;
        if (!AxTrade.CONFIG.getBoolean("prevent-adding-items-when-inventory-full", true)) {
            return false;
        }
        int filledSlots = this.getItems(false).size();
        if (filledSlots >= (emptySlots = this.player.getOtherPlayer().getEmptySlots())) {
            event.setCancelled(true);
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)this.player.getPlayer(), "trade.inventory-full", new TagResolver[0]);
            return true;
        }
        return false;
    }

    private void handleCurrencyClick(String currencyStr, InventoryClickEvent event) {
        event.setCancelled(true);
        if (!SafetyManager.CURRENCY_SELECTOR.get()) {
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)this.player.getPlayer(), "safety", new TagResolver[0]);
            return;
        }
        this.player.cancel();
        this.trade.update();
        this.inSign = true;
        this.trade.prepTime = System.currentTimeMillis();
        event.getWhoClicked().closeInventory();
        List<Component> lines = StringUtils.formatList(AxTrade.LANG.getStringList("currency-editor-sign"), new TagResolver[0]);
        lines.set(0, (Component)Component.empty());
        SignInput sign = new SignInput.Builder().setLines(lines).setHandler((player1, result) -> {
            if (this.trade.isEnded()) {
                return;
            }
            this.trade.prepTime = System.currentTimeMillis();
            String am = result[0];
            TradePlayer.Result addResult = this.player.setCurrency(currencyStr, am);
            if (addResult == TradePlayer.Result.SUCCESS) {
                AxTrade.MESSAGEUTILS.sendLang((CommandSender)player1, "currency-editor.success", new TagResolver[0]);
            } else {
                switch (addResult) {
                    case NOT_ENOUGH_CURRENCY: {
                        AxTrade.MESSAGEUTILS.sendLang((CommandSender)player1, "currency-editor.not-enough", new TagResolver[0]);
                        break;
                    }
                    default: {
                        AxTrade.MESSAGEUTILS.sendLang((CommandSender)player1, "currency-editor.failed", new TagResolver[0]);
                    }
                }
            }
            Scheduler.get().run(scheduledTask -> {
                if (this.trade.isEnded()) {
                    return;
                }
                this.gui.open((HumanEntity)this.player.getPlayer());
                this.inSign = false;
                this.trade.update();
                this.currentTitle = "";
                this.updateTitle();
            });
        }).build(this.player.getPlayer());
        sign.open();
    }

    public void handleShulkerClick(InventoryClickEvent event) {
        event.setCancelled(true);
        this.player.cancel();
        this.trade.update();
        this.inSign = true;
        this.trade.prepTime = System.currentTimeMillis();
        event.getWhoClicked().closeInventory();
        StorageGui shulkerGui = ((StorageBuilder)((StorageBuilder)((StorageBuilder)Gui.storage().rows(3)).title(StringUtils.format(Utils.getFormattedItemName(event.getCurrentItem()), new TagResolver[0]))).disableAllInteractions()).create();
        shulkerGui.getInventory().setContents(ShulkerUtils.getShulkerContents(event.getCurrentItem(), false));
        shulkerGui.setCloseGuiAction(e -> Scheduler.get().runLaterAt(this.player.getPlayer().getLocation(), () -> {
            if (this.trade.isEnded()) {
                return;
            }
            this.trade.prepTime = System.currentTimeMillis();
            this.gui.open((HumanEntity)this.player.getPlayer());
            this.inSign = false;
            this.trade.update();
            this.currentTitle = "";
            this.updateTitle();
        }, 1L));
        ((BaseGui)shulkerGui).open((HumanEntity)this.player.getPlayer());
    }

    @Nullable
    private ItemStack getItem(InventoryClickEvent event) {
        if (event.getClickedInventory() != null) {
            if (event.getClick() == ClickType.SWAP_OFFHAND && event.getClickedInventory().getType() != InventoryType.PLAYER) {
                return this.player.getPlayer().getInventory().getItemInOffHand();
            }
            if (event.getClick() == ClickType.NUMBER_KEY) {
                Inventory inventory = event.getClickedInventory().getType() == InventoryType.PLAYER ? event.getView().getTopInventory() : event.getView().getBottomInventory();
                return inventory.getItem(event.getHotbarButton());
            }
        }
        return event.getCurrentItem();
    }

    public List<ItemStack> getItems(boolean includeAir) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int slot : this.slots) {
            ItemStack item = this.gui.getInventory().getItem(slot);
            if (!includeAir && item == null) continue;
            items.add(item);
        }
        return items;
    }

    public void updateTitle() {
        String newTitle = AxTrade.GUIS.getString("title").replace("%player%", this.player.getOtherPlayer().getPlayer().getName()).replace("%own-status%", this.player.hasConfirmed() ? AxTrade.LANG.getString("placeholders.ready") : AxTrade.LANG.getString("placeholders.waiting")).replace("%partner-status%", this.player.getOtherPlayer().hasConfirmed() ? AxTrade.LANG.getString("placeholders.ready") : AxTrade.LANG.getString("placeholders.waiting"));
        if (this.currentTitle.equals(newTitle)) {
            return;
        }
        this.currentTitle = newTitle;
        Scheduler.get().runLater(task -> {
            Inventory topInv = this.player.getPlayer().getOpenInventory().getTopInventory();
            if (topInv.equals((Object)this.gui.getInventory())) {
                NMSHandlers.getNmsHandler().setTitle(this.player.getPlayer().getOpenInventory().getTopInventory(), StringUtils.format(newTitle, new TagResolver[0]));
            }
        }, 1L);
    }
}

