/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.utils;

import com.artillexstudios.axtrade.hooks.HookManager;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ShulkerUtils {
    @NotNull
    public static ItemStack[] getShulkerContents(ItemStack item, boolean includeSelf) {
        ItemStack[] items;
        if (item == null) {
            return new ItemStack[0];
        }
        if (HookManager.getAxShulkersHook() != null && (items = HookManager.getAxShulkersHook().getItems(item)) != null) {
            return items;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof BlockStateMeta)) {
            return new ItemStack[]{item};
        }
        BlockStateMeta meta = (BlockStateMeta)itemMeta;
        BlockState blockState = meta.getBlockState();
        if (!(blockState instanceof Container)) {
            return new ItemStack[]{item};
        }
        Container container = (Container)blockState;
        ItemStack[] storage = container.getInventory().getStorageContents();
        if (!includeSelf) {
            return storage;
        }
        ItemStack[] items2 = new ItemStack[storage.length + 1];
        System.arraycopy(storage, 0, items2, 0, storage.length);
        items2[storage.length - 1] = item;
        return items2;
    }
}

