/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.hooks;

import com.artillexstudios.axtrade.AxTrade;
import com.artillexstudios.axtrade.hooks.currency.AxQuestBoardHook;
import com.artillexstudios.axtrade.hooks.currency.BeastTokensHook;
import com.artillexstudios.axtrade.hooks.currency.CoinsEngineHook;
import com.artillexstudios.axtrade.hooks.currency.CurrencyHook;
import com.artillexstudios.axtrade.hooks.currency.EcoBitsHook;
import com.artillexstudios.axtrade.hooks.currency.ExperienceHook;
import com.artillexstudios.axtrade.hooks.currency.KingdomsXHook;
import com.artillexstudios.axtrade.hooks.currency.PlaceholderCurrencyHook;
import com.artillexstudios.axtrade.hooks.currency.PlayerPointsHook;
import com.artillexstudios.axtrade.hooks.currency.RedisEconomyHook;
import com.artillexstudios.axtrade.hooks.currency.RivalCreditsHook;
import com.artillexstudios.axtrade.hooks.currency.RivalHarvesterHoesHook;
import com.artillexstudios.axtrade.hooks.currency.RoyaleEconomyHook;
import com.artillexstudios.axtrade.hooks.currency.SuperMobCoinsHook;
import com.artillexstudios.axtrade.hooks.currency.TheOnlyMobCoins;
import com.artillexstudios.axtrade.hooks.currency.TokenManagerHook;
import com.artillexstudios.axtrade.hooks.currency.UltraEconomyHook;
import com.artillexstudios.axtrade.hooks.currency.VaultHook;
import com.artillexstudios.axtrade.hooks.other.AxShulkersHook;
import com.artillexstudios.axtrade.hooks.other.Placeholders;
import com.artillexstudios.axtrade.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axtrade.libs.axapi.utils.StringUtils;
import java.util.ArrayList;
import java.util.Map;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HookManager {
    private static final ArrayList<CurrencyHook> currency = new ArrayList();
    private static AxShulkersHook axShulkersHook = null;

    public static void setupHooks() {
        HookManager.updateHooks();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new Placeholders();
        }
        if (Bukkit.getPluginManager().getPlugin("AxShulkers") != null) {
            axShulkersHook = new AxShulkersHook();
        }
    }

    public static void updateHooks() {
        currency.removeIf(currencyHook -> !currencyHook.isPersistent());
        if (AxTrade.HOOKS.getBoolean("currencies.Experience.register", true)) {
            currency.add(new ExperienceHook());
        }
        if (AxTrade.HOOKS.getBoolean("currencies.Vault.register", true) && Bukkit.getPluginManager().getPlugin("Vault") != null) {
            currency.add(new VaultHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Hooked into Vault!", new TagResolver[0]));
        }
        if (AxTrade.HOOKS.getBoolean("currencies.PlayerPoints.register", true) && Bukkit.getPluginManager().getPlugin("PlayerPoints") != null) {
            currency.add(new PlayerPointsHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Hooked into PlayerPoints!", new TagResolver[0]));
        }
        if (AxTrade.HOOKS.getBoolean("currencies.CoinsEngine.register", true) && Bukkit.getPluginManager().getPlugin("CoinsEngine") != null) {
            for (Map<Object, Object> map : AxTrade.HOOKS.getMapList("currencies.CoinsEngine.enabled")) {
                currency.add(new CoinsEngineHook(map));
            }
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Hooked into CoinsEngine!", new TagResolver[0]));
        }
        if (AxTrade.HOOKS.getBoolean("currencies.RoyaleEconomy.register", true) && Bukkit.getPluginManager().getPlugin("RoyaleEconomy") != null) {
            currency.add(new RoyaleEconomyHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Hooked into RoyaleEconomy!", new TagResolver[0]));
        }
        if (AxTrade.HOOKS.getBoolean("currencies.UltraEconomy.register", true) && Bukkit.getPluginManager().getPlugin("UltraEconomy") != null) {
            for (Map<Object, Object> map : AxTrade.HOOKS.getMapList("currencies.UltraEconomy.enabled")) {
                currency.add(new UltraEconomyHook(map));
            }
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Hooked into UltraEconomy!", new TagResolver[0]));
        }
        if (AxTrade.HOOKS.getBoolean("currencies.KingdomsX.register", true) && Bukkit.getPluginManager().getPlugin("Kingdoms") != null) {
            currency.add(new KingdomsXHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Hooked into KingdomsX!", new TagResolver[0]));
        }
        if (AxTrade.HOOKS.getBoolean("currencies.RivalHarvesterHoes.register", true) && Bukkit.getPluginManager().getPlugin("RivalHarvesterHoes") != null) {
            currency.add(new RivalHarvesterHoesHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Hooked into RivalHarvesterHoes!", new TagResolver[0]));
        }
        if (AxTrade.HOOKS.getBoolean("currencies.SuperMobCoins.register", true) && Bukkit.getPluginManager().getPlugin("SuperMobCoins") != null) {
            currency.add(new SuperMobCoinsHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Hooked into SuperMobCoins!", new TagResolver[0]));
        }
        if (AxTrade.HOOKS.getBoolean("currencies.TheOnly-MobCoins.register", true) && Bukkit.getPluginManager().getPlugin("TheOnly-MobCoins") != null) {
            currency.add(new TheOnlyMobCoins());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Hooked into TheOnly-MobCoins!", new TagResolver[0]));
        }
        if (AxTrade.HOOKS.getBoolean("currencies.TokenManager.register", true) && Bukkit.getPluginManager().getPlugin("TokenManager") != null) {
            currency.add(new TokenManagerHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Hooked into TokenManager!", new TagResolver[0]));
        }
        if (AxTrade.HOOKS.getBoolean("currencies.AxQuestBoard.register", true) && Bukkit.getPluginManager().getPlugin("AxQuestBoard") != null) {
            currency.add(new AxQuestBoardHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Hooked into AxQuestBoard!", new TagResolver[0]));
        }
        if (AxTrade.HOOKS.getBoolean("currencies.RedisEconomy.register", true) && Bukkit.getPluginManager().getPlugin("RedisEconomy") != null) {
            for (Map<Object, Object> map : AxTrade.HOOKS.getMapList("currencies.RedisEconomy.enabled")) {
                currency.add(new RedisEconomyHook(map));
            }
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Hooked into RedisEconomy!", new TagResolver[0]));
        }
        if (AxTrade.HOOKS.getBoolean("currencies.BeastTokens.register", true) && Bukkit.getPluginManager().getPlugin("BeastTokens") != null) {
            currency.add(new BeastTokensHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Hooked into BeastTokens!", new TagResolver[0]));
        }
        if (AxTrade.HOOKS.getBoolean("currencies.EcoBits.register", true) && Bukkit.getPluginManager().getPlugin("EcoBits") != null) {
            for (Map map : AxTrade.HOOKS.getMapList("currencies.EcoBits.enabled")) {
                currency.add(new EcoBitsHook(map));
            }
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Hooked into EcoBits!", new TagResolver[0]));
        }
        if (AxTrade.HOOKS.getBoolean("currencies.RivalCredits.register", true) && Bukkit.getPluginManager().getPlugin("RivalCredits") != null) {
            currency.add(new RivalCreditsHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Hooked into RivalCredits!", new TagResolver[0]));
        }
        for (String string : AxTrade.HOOKS.getSection("placeholder-currencies").getRoutesAsStrings(false)) {
            if (!AxTrade.HOOKS.getBoolean("placeholder-currencies." + string + ".register", false)) continue;
            currency.add(new PlaceholderCurrencyHook(string, AxTrade.HOOKS.getSection("placeholder-currencies." + string)));
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Loaded placeholder currency " + string + "!", new TagResolver[0]));
        }
        for (CurrencyHook currencyHook2 : currency) {
            currencyHook2.setup();
        }
    }

    public static void registerCurrencyHook(@NotNull Plugin plugin, @NotNull CurrencyHook currencyHook) {
        currency.add(currencyHook);
        Section section = AxTrade.HOOKS.getSection("currencies." + currencyHook.getName());
        if (section == null) {
            section = AxTrade.HOOKS.getBackingDocument().createSection("currencies." + currencyHook.getName());
            section.set("enabled", (Object)true);
            section.set("name", (Object)currencyHook.getName());
            section.set("tax", (Object)0);
            AxTrade.HOOKS.save();
        }
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Hooked into " + plugin.getName() + "! Note: Check the currencies.yml for settings!", new TagResolver[0]));
    }

    @NotNull
    public static ArrayList<CurrencyHook> getCurrency() {
        return currency;
    }

    @Nullable
    public static CurrencyHook getCurrencyHook(@NotNull String name) {
        for (CurrencyHook hook : currency) {
            if (!hook.getName().equals(name)) continue;
            return hook;
        }
        return null;
    }

    public static AxShulkersHook getAxShulkersHook() {
        return axShulkersHook;
    }
}

