/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.hooks.currency;

import com.artillexstudios.axtrade.hooks.currency.CurrencyHook;
import com.artillexstudios.axtrade.libs.axapi.utils.StringUtils;
import com.willfp.ecobits.currencies.Currencies;
import com.willfp.ecobits.currencies.Currency;
import com.willfp.ecobits.currencies.CurrencyUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class EcoBitsHook
implements CurrencyHook {
    private Currency currency = null;
    private final Map<String, Object> settings;
    private final String internal;

    public EcoBitsHook(Map<Object, Object> settings) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : settings.entrySet()) {
            map.put((String)entry.getKey(), entry.getValue());
        }
        this.settings = map;
        this.internal = (String)settings.get("currency-name");
    }

    @Override
    public void setup() {
        this.currency = Currencies.getByID((String)this.internal);
        if (this.currency == null) {
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF0000[AxTrade] EcoBits currency named &#DD0000" + this.internal + " &#FF0000not found! Change the currency-name or disable the hook to get rid of this warning!", new TagResolver[0]));
        }
    }

    @Override
    public String getName() {
        return "EcoBits-" + this.internal;
    }

    @Override
    public Map<String, Object> getSettings() {
        return this.settings;
    }

    @Override
    public boolean worksOffline() {
        return false;
    }

    @Override
    public boolean usesDouble() {
        return true;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public double getBalance(@NotNull UUID player) {
        if (this.currency == null) {
            return 0.0;
        }
        return CurrencyUtils.getBalance((OfflinePlayer)Bukkit.getOfflinePlayer((UUID)player), (Currency)this.currency).doubleValue();
    }

    @Override
    public CompletableFuture<Boolean> giveBalance(@NotNull UUID player, double amount) {
        if (this.currency == null) {
            return CompletableFuture.completedFuture(false);
        }
        CurrencyUtils.adjustBalance((OfflinePlayer)Bukkit.getOfflinePlayer((UUID)player), (Currency)this.currency, (BigDecimal)BigDecimal.valueOf(amount));
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> takeBalance(@NotNull UUID player, double amount) {
        if (this.currency == null) {
            return CompletableFuture.completedFuture(false);
        }
        CurrencyUtils.adjustBalance((OfflinePlayer)Bukkit.getOfflinePlayer((UUID)player), (Currency)this.currency, (BigDecimal)BigDecimal.valueOf(amount * -1.0));
        return CompletableFuture.completedFuture(true);
    }
}

