/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.libs.axapi.packetentity.meta.serializer;

import com.artillexstudios.axtrade.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axtrade.libs.axapi.items.component.type.ProfileProperties;
import com.artillexstudios.axtrade.libs.axapi.items.nbt.CompoundTag;
import com.artillexstudios.axtrade.libs.axapi.packet.FriendlyByteBuf;
import com.artillexstudios.axtrade.libs.axapi.packet.data.GlobalPosition;
import com.artillexstudios.axtrade.libs.axapi.packet.data.VillagerData;
import com.artillexstudios.axtrade.libs.axapi.packetentity.meta.serializer.EntityDataSerializer;
import com.artillexstudios.axtrade.libs.axapi.particle.ParticleData;
import com.artillexstudios.axtrade.libs.axapi.particle.ParticleOption;
import com.artillexstudios.axtrade.libs.axapi.particle.ParticleTypes;
import com.artillexstudios.axtrade.libs.axapi.utils.ClientAsset;
import com.artillexstudios.axtrade.libs.axapi.utils.Direction;
import com.artillexstudios.axtrade.libs.axapi.utils.GameProfile;
import com.artillexstudios.axtrade.libs.axapi.utils.PlayerModelType;
import com.artillexstudios.axtrade.libs.axapi.utils.PlayerSkin;
import com.artillexstudios.axtrade.libs.axapi.utils.Quaternion;
import com.artillexstudios.axtrade.libs.axapi.utils.ResolvableProfile;
import com.artillexstudios.axtrade.libs.axapi.utils.Vector3f;
import com.artillexstudios.axtrade.libs.axapi.utils.Version;
import com.artillexstudios.axtrade.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axtrade.libs.axapi.utils.logging.LogUtils;
import com.artillexstudios.axtrade.libs.axapi.utils.position.BlockPosition;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Pose;
import org.bukkit.util.EulerAngle;

public final class EntityDataSerializers {
    private static final Int2ObjectArrayMap<EntityDataSerializer<?>> SERIALIZERS = new Int2ObjectArrayMap();
    private static final Object2IntArrayMap<EntityDataSerializer<?>> REVERSE_SERIALIZERS = new Object2IntArrayMap();
    public static final EntityDataSerializer<Byte> BYTE = new EntityDataSerializer<Byte>(){

        @Override
        public void write(FriendlyByteBuf buf, Byte value) {
            buf.writeByte(value.byteValue());
        }

        @Override
        public Byte read(FriendlyByteBuf buf) {
            return buf.readByte();
        }

        @Override
        public Type type() {
            return Type.BYTE;
        }
    };
    public static final EntityDataSerializer<Integer> INT = new EntityDataSerializer<Integer>(){

        @Override
        public void write(FriendlyByteBuf buf, Integer value) {
            buf.writeVarInt(value);
        }

        @Override
        public Integer read(FriendlyByteBuf buf) {
            return buf.readVarInt();
        }

        @Override
        public Type type() {
            return Type.INT;
        }
    };
    public static final EntityDataSerializer<Long> LONG = new EntityDataSerializer<Long>(){

        @Override
        public void write(FriendlyByteBuf buf, Long value) {
            buf.writeVarLong(value);
        }

        @Override
        public Long read(FriendlyByteBuf buf) {
            return buf.readVarLong();
        }

        @Override
        public Type type() {
            return Type.LONG;
        }
    };
    public static final EntityDataSerializer<Float> FLOAT = new EntityDataSerializer<Float>(){

        @Override
        public void write(FriendlyByteBuf buf, Float value) {
            buf.writeFloat(value.floatValue());
        }

        @Override
        public Float read(FriendlyByteBuf buf) {
            return Float.valueOf(buf.readFloat());
        }

        @Override
        public Type type() {
            return Type.FLOAT;
        }
    };
    public static final EntityDataSerializer<String> STRING = new EntityDataSerializer<String>(){

        @Override
        public void write(FriendlyByteBuf buf, String value) {
            buf.writeUTF(value);
        }

        @Override
        public String read(FriendlyByteBuf buf) {
            return buf.readUTF();
        }

        @Override
        public Type type() {
            return Type.STRING;
        }
    };
    public static final EntityDataSerializer<Component> COMPONENT = new EntityDataSerializer<Component>(){

        @Override
        public void write(FriendlyByteBuf buf, Component value) {
            buf.writeComponent(value);
        }

        @Override
        public Component read(FriendlyByteBuf buf) {
            return buf.readComponent();
        }

        @Override
        public Type type() {
            return Type.COMPONENT;
        }
    };
    public static final EntityDataSerializer<Optional<Component>> OPTIONAL_COMPONENT = new EntityDataSerializer<Optional<Component>>(){

        @Override
        public void write(FriendlyByteBuf buf, Optional<Component> value) {
            if (value.isPresent()) {
                buf.writeBoolean(true);
                buf.writeComponent(value.get());
            } else {
                buf.writeBoolean(false);
            }
        }

        @Override
        public Optional<Component> read(FriendlyByteBuf buf) {
            return buf.readBoolean() ? Optional.of(buf.readComponent()) : Optional.empty();
        }

        @Override
        public Type type() {
            return Type.OPTIONAL_COMPONENT;
        }
    };
    public static final EntityDataSerializer<WrappedItemStack> ITEM_STACK = new EntityDataSerializer<WrappedItemStack>(){

        @Override
        public void write(FriendlyByteBuf buf, WrappedItemStack value) {
            buf.writeItemStack(value);
        }

        @Override
        public WrappedItemStack read(FriendlyByteBuf buf) {
            return buf.readItemStack();
        }

        @Override
        public Type type() {
            return Type.ITEM_STACK;
        }
    };
    public static final EntityDataSerializer<BlockData> BLOCK_DATA = new EntityDataSerializer<BlockData>(){

        @Override
        public void write(FriendlyByteBuf buf, BlockData value) {
            buf.writeBlockData(value);
        }

        @Override
        public BlockData read(FriendlyByteBuf buf) {
            return buf.readBlockData();
        }

        @Override
        public Type type() {
            return Type.BLOCK_DATA;
        }
    };
    public static final EntityDataSerializer<Boolean> BOOLEAN = new EntityDataSerializer<Boolean>(){

        @Override
        public void write(FriendlyByteBuf buf, Boolean value) {
            buf.writeBoolean(value);
        }

        @Override
        public Boolean read(FriendlyByteBuf buf) {
            return buf.readBoolean();
        }

        @Override
        public Type type() {
            return Type.BOOLEAN;
        }
    };
    public static final EntityDataSerializer<ParticleData<? extends ParticleOption>> PARTICLE = new EntityDataSerializer<ParticleData<? extends ParticleOption>>(){

        @Override
        public void write(FriendlyByteBuf buf, ParticleData<? extends ParticleOption> value) {
            ParticleTypes.write(value, buf);
        }

        @Override
        public ParticleData<? extends ParticleOption> read(FriendlyByteBuf buf) {
            return ParticleTypes.read(buf);
        }

        @Override
        public Type type() {
            return Type.PARTICLE;
        }
    };
    public static final EntityDataSerializer<EulerAngle> ROTATIONS = new EntityDataSerializer<EulerAngle>(){

        @Override
        public void write(FriendlyByteBuf buf, EulerAngle value) {
            buf.writeFloat((float)value.getX());
            buf.writeFloat((float)value.getY());
            buf.writeFloat((float)value.getZ());
        }

        @Override
        public EulerAngle read(FriendlyByteBuf buf) {
            return new EulerAngle((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
        }

        @Override
        public Type type() {
            return Type.ROTATIONS;
        }
    };
    public static final EntityDataSerializer<BlockPosition> BLOCK_POSITION = new EntityDataSerializer<BlockPosition>(){

        @Override
        public void write(FriendlyByteBuf buf, BlockPosition value) {
            buf.writeBlockPos(value);
        }

        @Override
        public BlockPosition read(FriendlyByteBuf buf) {
            return buf.readBlockPosition();
        }

        @Override
        public Type type() {
            return Type.LOCATION;
        }
    };
    public static final EntityDataSerializer<Optional<BlockPosition>> OPTIONAL_BLOCK_POSITION = new EntityDataSerializer<Optional<BlockPosition>>(){

        @Override
        public void write(FriendlyByteBuf buf, Optional<BlockPosition> value) {
            if (value.isPresent()) {
                buf.writeBoolean(true);
                BlockPosition pos = value.get();
                buf.writeBlockPos(pos);
            } else {
                buf.writeBoolean(false);
            }
        }

        @Override
        public Optional<BlockPosition> read(FriendlyByteBuf buf) {
            return !buf.readBoolean() ? Optional.empty() : Optional.of(buf.readBlockPosition());
        }

        @Override
        public Type type() {
            return Type.OPTIONAL_LOCATION;
        }
    };
    public static final EntityDataSerializer<Pose> POSE = new EntityDataSerializer<Pose>(){

        @Override
        public void write(FriendlyByteBuf buf, Pose value) {
            buf.writeVarInt(value.ordinal());
        }

        @Override
        public Pose read(FriendlyByteBuf buf) {
            return Pose.values()[buf.readVarInt()];
        }

        @Override
        public Type type() {
            return Type.POSE;
        }
    };
    public static final EntityDataSerializer<Integer> CAT_VARIANT = new EntityDataSerializer<Integer>(){

        @Override
        public void write(FriendlyByteBuf buf, Integer value) {
            buf.writeVarInt(value);
        }

        @Override
        public Integer read(FriendlyByteBuf buf) {
            return buf.readVarInt();
        }

        @Override
        public Type type() {
            return Type.CAT_VARIANT;
        }
    };
    public static final EntityDataSerializer<Integer> WOLF_VARIANT = new EntityDataSerializer<Integer>(){

        @Override
        public void write(FriendlyByteBuf buf, Integer value) {
            buf.writeVarInt(value);
        }

        @Override
        public Integer read(FriendlyByteBuf buf) {
            return buf.readVarInt();
        }

        @Override
        public Type type() {
            return Type.WOLF_VARIANT;
        }
    };
    public static final EntityDataSerializer<Integer> FROG_VARIANT = new EntityDataSerializer<Integer>(){

        @Override
        public void write(FriendlyByteBuf buf, Integer value) {
            buf.writeVarInt(value);
        }

        @Override
        public Integer read(FriendlyByteBuf buf) {
            return buf.readVarInt();
        }

        @Override
        public Type type() {
            return Type.INT;
        }
    };
    public static final EntityDataSerializer<Integer> PAINTING_VARIANT = new EntityDataSerializer<Integer>(){

        @Override
        public void write(FriendlyByteBuf buf, Integer value) {
            buf.writeVarInt(value);
        }

        @Override
        public Integer read(FriendlyByteBuf buf) {
            return buf.readVarInt();
        }

        @Override
        public Type type() {
            return Type.INT;
        }
    };
    public static final EntityDataSerializer<Vector3f> VECTOR3 = new EntityDataSerializer<Vector3f>(){

        @Override
        public void write(FriendlyByteBuf buf, Vector3f value) {
            buf.writeFloat(value.x());
            buf.writeFloat(value.y());
            buf.writeFloat(value.z());
        }

        @Override
        public Vector3f read(FriendlyByteBuf buf) {
            return new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
        }

        @Override
        public Type type() {
            return Type.VECTOR3;
        }
    };
    public static final EntityDataSerializer<Quaternion> QUATERNION = new EntityDataSerializer<Quaternion>(){

        @Override
        public void write(FriendlyByteBuf buf, Quaternion value) {
            buf.writeFloat(value.x());
            buf.writeFloat(value.y());
            buf.writeFloat(value.z());
            buf.writeFloat(value.w());
        }

        @Override
        public Quaternion read(FriendlyByteBuf buf) {
            return new Quaternion(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
        }

        @Override
        public Type type() {
            return Type.QUATERNION;
        }
    };
    public static final EntityDataSerializer<Integer> COPPER_GOLEM_STATE = new EntityDataSerializer<Integer>(){

        @Override
        public void write(FriendlyByteBuf buf, Integer value) {
            buf.writeVarInt(value);
        }

        @Override
        public Integer read(FriendlyByteBuf buf) {
            return buf.readVarInt();
        }

        @Override
        public Type type() {
            return Type.COPPER_GOLEM_STATE;
        }
    };
    public static final EntityDataSerializer<Integer> WEATHERING_COPPER_STATE = new EntityDataSerializer<Integer>(){

        @Override
        public void write(FriendlyByteBuf buf, Integer value) {
            buf.writeVarInt(value);
        }

        @Override
        public Integer read(FriendlyByteBuf buf) {
            return buf.readVarInt();
        }

        @Override
        public Type type() {
            return Type.WEATHERING_COPPER_STATE;
        }
    };
    public static final EntityDataSerializer<ResolvableProfile> RESOLVABLE_PROFILE = new EntityDataSerializer<ResolvableProfile>(){

        @Override
        public void write(FriendlyByteBuf buf, ResolvableProfile value) {
            boolean partial = value.getPartialProfile().name() == null || value.getPartialProfile().uuid() == null;
            buf.writeBoolean(!partial);
            if (!partial) {
                buf.writeUUID(value.getPartialProfile().uuid());
                buf.writeUTF(value.getPartialProfile().name());
            } else {
                buf.writeBoolean(value.getPartialProfile().name() != null);
                if (value.getPartialProfile().name() != null) {
                    buf.writeUTF(value.getPartialProfile().name());
                }
                buf.writeBoolean(value.getPartialProfile().uuid() != null);
                if (value.getPartialProfile().uuid() != null) {
                    buf.writeUUID(value.getPartialProfile().uuid());
                }
            }
            buf.writeVarInt(value.getPartialProfile().properties().properties().size());
            for (Map.Entry entry : value.getPartialProfile().properties().properties().entries()) {
                buf.writeUTF((String)entry.getKey());
                buf.writeUTF(((ProfileProperties.Property)entry.getValue()).value());
                buf.writeUTF(((ProfileProperties.Property)entry.getValue()).signature());
            }
            value.getPatch().body().ifPresentOrElse(texture -> {
                buf.writeBoolean(true);
                buf.writeResourceLocation(texture.id());
            }, () -> buf.writeBoolean(false));
            value.getPatch().cape().ifPresentOrElse(texture -> {
                buf.writeBoolean(true);
                buf.writeResourceLocation(texture.id());
            }, () -> buf.writeBoolean(false));
            value.getPatch().elytra().ifPresentOrElse(texture -> {
                buf.writeBoolean(true);
                buf.writeResourceLocation(texture.id());
            }, () -> buf.writeBoolean(false));
            value.getPatch().model().ifPresentOrElse(texture -> {
                buf.writeBoolean(true);
                buf.writeEnum(texture);
            }, () -> buf.writeBoolean(false));
        }

        @Override
        public ResolvableProfile read(FriendlyByteBuf buf) {
            String name;
            UUID uuid;
            boolean gameProfile = buf.readBoolean();
            if (gameProfile) {
                uuid = buf.readUUID();
                name = buf.readUTF(16);
            } else {
                boolean namePresent = buf.readBoolean();
                name = namePresent ? buf.readUTF(16) : null;
                boolean uuidPresent = buf.readBoolean();
                uuid = uuidPresent ? buf.readUUID() : null;
            }
            ProfileProperties properties = new ProfileProperties(uuid, name);
            int count = buf.readVarInt();
            if (count > 16) {
                throw new RuntimeException("Reading illegal profile!");
            }
            for (int i = 0; i < count; ++i) {
                String propertyName = buf.readUTF(64);
                String propertyValue = buf.readUTF(Short.MAX_VALUE);
                String propertySignature = buf.readBoolean() ? buf.readUTF(1024) : null;
                properties.put(propertyName, new ProfileProperties.Property(propertyName, propertyValue, propertySignature));
            }
            boolean bodyPresent = buf.readBoolean();
            Optional<ClientAsset.ResourceTexture> body = bodyPresent ? Optional.of(new ClientAsset.ResourceTexture(buf.readResourceLocation())) : Optional.empty();
            boolean capePresent = buf.readBoolean();
            Optional<ClientAsset.ResourceTexture> cape = capePresent ? Optional.of(new ClientAsset.ResourceTexture(buf.readResourceLocation())) : Optional.empty();
            boolean elytraPresent = buf.readBoolean();
            Optional<ClientAsset.ResourceTexture> elytra = elytraPresent ? Optional.of(new ClientAsset.ResourceTexture(buf.readResourceLocation())) : Optional.empty();
            boolean modelTypePresent = buf.readBoolean();
            Optional<PlayerModelType> modelType = modelTypePresent ? Optional.of(buf.readEnum(PlayerModelType.class)) : Optional.empty();
            PlayerSkin.Patch patch = new PlayerSkin.Patch(body, cape, elytra, modelType);
            GameProfile builtProfile = new GameProfile(name, uuid, properties);
            return new ResolvableProfile(builtProfile, patch);
        }

        @Override
        public Type type() {
            return Type.RESOLVABLE_PROFILE;
        }
    };
    public static final EntityDataSerializer<Optional<UUID>> OPTIONAL_UUID = new EntityDataSerializer<Optional<UUID>>(){

        @Override
        public void write(FriendlyByteBuf buf, Optional<UUID> value) {
            if (value.isPresent()) {
                buf.writeBoolean(true);
                UUID uuid = value.get();
                buf.writeLong(uuid.getMostSignificantBits());
                buf.writeLong(uuid.getLeastSignificantBits());
            } else {
                buf.writeBoolean(false);
            }
        }

        @Override
        public Optional<UUID> read(FriendlyByteBuf buf) {
            return buf.readBoolean() ? Optional.of(new UUID(buf.readLong(), buf.readLong())) : Optional.empty();
        }

        @Override
        public Type type() {
            return Type.OPTIONAL_UUID;
        }
    };
    public static final EntityDataSerializer<CompoundTag> COMPOUND_TAG = new EntityDataSerializer<CompoundTag>(){

        @Override
        public void write(FriendlyByteBuf buf, CompoundTag value) {
            buf.writeNBT(value);
        }

        @Override
        public CompoundTag read(FriendlyByteBuf buf) {
            return buf.readNBT();
        }

        @Override
        public Type type() {
            return Type.COMPOUND_TAG;
        }
    };
    public static final EntityDataSerializer<Integer> SNIFFER_STATE = new EntityDataSerializer<Integer>(){

        @Override
        public void write(FriendlyByteBuf buf, Integer value) {
            buf.writeVarInt(value);
        }

        @Override
        public Integer read(FriendlyByteBuf buf) {
            return buf.readVarInt();
        }

        @Override
        public Type type() {
            return Type.SNIFFER_STATE;
        }
    };
    public static final EntityDataSerializer<Integer> ARMADILLO_STATE = new EntityDataSerializer<Integer>(){

        @Override
        public void write(FriendlyByteBuf buf, Integer value) {
            buf.writeVarInt(value);
        }

        @Override
        public Integer read(FriendlyByteBuf buf) {
            return buf.readVarInt();
        }

        @Override
        public Type type() {
            return Type.ARMADILLO_STATE;
        }
    };
    public static final EntityDataSerializer<List<ParticleData<? extends ParticleOption>>> PARTICLES = new EntityDataSerializer<List<ParticleData<? extends ParticleOption>>>(){

        @Override
        public void write(FriendlyByteBuf buf, List<ParticleData<? extends ParticleOption>> value) {
            buf.writeVarInt(value.size());
            for (ParticleData<? extends ParticleOption> option : value) {
                PARTICLE.write(buf, option);
            }
        }

        @Override
        public List<ParticleData<? extends ParticleOption>> read(FriendlyByteBuf buf) {
            int size = buf.readVarInt();
            ArrayList<ParticleData<? extends ParticleOption>> options = new ArrayList<ParticleData<? extends ParticleOption>>();
            for (int i = 0; i < size; ++i) {
                options.add(PARTICLE.read(buf));
            }
            return options;
        }

        @Override
        public Type type() {
            return Type.PARTICLES;
        }
    };
    public static final EntityDataSerializer<Direction> DIRECTION = new EntityDataSerializer<Direction>(){

        @Override
        public void write(FriendlyByteBuf buf, Direction value) {
            buf.writeVarInt(value.ordinal());
        }

        @Override
        public Direction read(FriendlyByteBuf buf) {
            return Direction.values()[buf.readVarInt()];
        }

        @Override
        public Type type() {
            return Type.DIRECTION;
        }
    };
    public static final EntityDataSerializer<VillagerData> VILLAGER_DATA = new EntityDataSerializer<VillagerData>(){

        @Override
        public void write(FriendlyByteBuf buf, VillagerData value) {
            buf.writeVarInt(value.getType());
            buf.writeVarInt(value.getProfession());
            buf.writeVarInt(value.getLevel());
        }

        @Override
        public VillagerData read(FriendlyByteBuf buf) {
            return new VillagerData(buf.readVarInt(), buf.readVarInt(), buf.readVarInt());
        }

        @Override
        public Type type() {
            return Type.VILLAGER_DATA;
        }
    };
    public static final EntityDataSerializer<OptionalInt> OPTIONAL_UNSIGNED_INT = new EntityDataSerializer<OptionalInt>(){

        @Override
        public void write(FriendlyByteBuf buf, OptionalInt value) {
            buf.writeVarInt(value.orElse(-1) + 1);
        }

        @Override
        public OptionalInt read(FriendlyByteBuf buf) {
            int i = buf.readVarInt();
            return i == 0 ? OptionalInt.empty() : OptionalInt.of(i - 1);
        }

        @Override
        public Type type() {
            return Type.OPTIONAL_UNSIGNED_INT;
        }
    };
    public static final EntityDataSerializer<Optional<GlobalPosition>> OPTIONAL_GLOBAL_POS = new EntityDataSerializer<Optional<GlobalPosition>>(){

        @Override
        public void write(FriendlyByteBuf buf, Optional<GlobalPosition> value) {
            if (value.isPresent()) {
                buf.writeBoolean(true);
                GlobalPosition pos = value.get();
                buf.writeResourceLocation(pos.key());
                buf.writeBlockPos(pos.position());
            } else {
                buf.writeBoolean(false);
            }
        }

        @Override
        public Optional<GlobalPosition> read(FriendlyByteBuf buf) {
            return buf.readBoolean() ? Optional.of(new GlobalPosition(buf.readResourceLocation(), buf.readBlockPosition())) : Optional.empty();
        }

        @Override
        public Type type() {
            return Type.OPTIONAL_GLOBAL_POS;
        }
    };
    public static final EntityDataSerializer<OptionalInt> OPTIONAL_BLOCK_DATA = new EntityDataSerializer<OptionalInt>(){

        @Override
        public void write(FriendlyByteBuf buf, OptionalInt value) {
            if (value.isPresent()) {
                buf.writeVarInt(value.getAsInt());
            } else {
                buf.writeVarInt(0);
            }
        }

        @Override
        public OptionalInt read(FriendlyByteBuf buf) {
            int i = buf.readVarInt();
            return i != 0 ? OptionalInt.of(i) : OptionalInt.empty();
        }

        @Override
        public Type type() {
            return Type.OPTIONAL_BLOCK_DATA;
        }
    };
    public static final EntityDataSerializer<Integer> COW_VARIANT = new EntityDataSerializer<Integer>(){

        @Override
        public void write(FriendlyByteBuf buf, Integer value) {
            buf.writeVarInt(value);
        }

        @Override
        public Integer read(FriendlyByteBuf buf) {
            return buf.readVarInt();
        }

        @Override
        public Type type() {
            return Type.COW_VARIANT;
        }
    };
    public static final EntityDataSerializer<Integer> CHICKEN_VARIANT = new EntityDataSerializer<Integer>(){

        @Override
        public void write(FriendlyByteBuf buf, Integer value) {
            buf.writeVarInt(value);
        }

        @Override
        public Integer read(FriendlyByteBuf buf) {
            return buf.readVarInt();
        }

        @Override
        public Type type() {
            return Type.CHICKEN_VARIANT;
        }
    };
    public static final EntityDataSerializer<Integer> WOLF_SOUND_VARIANT = new EntityDataSerializer<Integer>(){

        @Override
        public void write(FriendlyByteBuf buf, Integer value) {
            buf.writeVarInt(value);
        }

        @Override
        public Integer read(FriendlyByteBuf buf) {
            return buf.readVarInt();
        }

        @Override
        public Type type() {
            return Type.WOLF_SOUND_VARIANT;
        }
    };
    public static final EntityDataSerializer<Integer> PIG_VARIANT = new EntityDataSerializer<Integer>(){

        @Override
        public void write(FriendlyByteBuf buf, Integer value) {
            buf.writeVarInt(value);
        }

        @Override
        public Integer read(FriendlyByteBuf buf) {
            return buf.readVarInt();
        }

        @Override
        public Type type() {
            return Type.PIG_VARIANT;
        }
    };

    public static <T> EntityDataSerializer<T> byId(int id) {
        return (EntityDataSerializer)SERIALIZERS.get(id);
    }

    public static <T> int getId(EntityDataSerializer<T> serializer) {
        return REVERSE_SERIALIZERS.getInt(serializer);
    }

    private static <T> void register(EntityDataSerializer<T> serializer) {
        int index = SERIALIZERS.size();
        SERIALIZERS.put(index, serializer);
        REVERSE_SERIALIZERS.put(serializer, index);
        if (((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) {
            LogUtils.debug("Registering entitydata serializer: {}", (Object)serializer.type());
        }
    }

    static {
        EntityDataSerializers.register(BYTE);
        EntityDataSerializers.register(INT);
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_19_2)) {
            EntityDataSerializers.register(LONG);
        }
        EntityDataSerializers.register(FLOAT);
        EntityDataSerializers.register(STRING);
        EntityDataSerializers.register(COMPONENT);
        EntityDataSerializers.register(OPTIONAL_COMPONENT);
        EntityDataSerializers.register(ITEM_STACK);
        EntityDataSerializers.register(BOOLEAN);
        EntityDataSerializers.register(ROTATIONS);
        EntityDataSerializers.register(BLOCK_POSITION);
        EntityDataSerializers.register(OPTIONAL_BLOCK_POSITION);
        EntityDataSerializers.register(DIRECTION);
        EntityDataSerializers.register(OPTIONAL_UUID);
        EntityDataSerializers.register(BLOCK_DATA);
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_19_3)) {
            EntityDataSerializers.register(OPTIONAL_BLOCK_DATA);
        }
        if (Version.getServerVersion().isOlderThanOrEqualTo(Version.v1_21_6)) {
            EntityDataSerializers.register(COMPOUND_TAG);
        }
        EntityDataSerializers.register(PARTICLE);
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_20_4)) {
            EntityDataSerializers.register(PARTICLES);
        }
        EntityDataSerializers.register(VILLAGER_DATA);
        EntityDataSerializers.register(OPTIONAL_UNSIGNED_INT);
        EntityDataSerializers.register(POSE);
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_19)) {
            EntityDataSerializers.register(CAT_VARIANT);
            if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_21_4)) {
                EntityDataSerializers.register(COW_VARIANT);
            }
            if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_20_4)) {
                EntityDataSerializers.register(WOLF_VARIANT);
            }
            if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_21_4)) {
                EntityDataSerializers.register(WOLF_SOUND_VARIANT);
            }
            EntityDataSerializers.register(FROG_VARIANT);
            if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_21_4)) {
                EntityDataSerializers.register(PIG_VARIANT);
                EntityDataSerializers.register(CHICKEN_VARIANT);
            }
            EntityDataSerializers.register(OPTIONAL_GLOBAL_POS);
            EntityDataSerializers.register(PAINTING_VARIANT);
            EntityDataSerializers.register(SNIFFER_STATE);
            if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_20_4)) {
                EntityDataSerializers.register(ARMADILLO_STATE);
                if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_21_7)) {
                    EntityDataSerializers.register(COPPER_GOLEM_STATE);
                    EntityDataSerializers.register(WEATHERING_COPPER_STATE);
                }
            }
            EntityDataSerializers.register(VECTOR3);
            EntityDataSerializers.register(QUATERNION);
            if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_21_7)) {
                EntityDataSerializers.register(RESOLVABLE_PROFILE);
            }
        }
    }

    public static enum Type {
        BYTE,
        INT,
        LONG,
        FLOAT,
        STRING,
        COMPONENT,
        OPTIONAL_COMPONENT,
        ITEM_STACK,
        BLOCK_DATA,
        BOOLEAN,
        PARTICLE,
        ROTATIONS,
        LOCATION,
        OPTIONAL_LOCATION,
        POSE,
        VECTOR3,
        QUATERNION,
        PARTICLES,
        ARMADILLO_STATE,
        SNIFFER_STATE,
        COPPER_GOLEM_STATE,
        WEATHERING_COPPER_STATE,
        COMPOUND_TAG,
        OPTIONAL_UUID,
        WOLF_VARIANT,
        CAT_VARIANT,
        DIRECTION,
        VILLAGER_DATA,
        OPTIONAL_UNSIGNED_INT,
        OPTIONAL_GLOBAL_POS,
        OPTIONAL_BLOCK_DATA,
        COW_VARIANT,
        WOLF_SOUND_VARIANT,
        PIG_VARIANT,
        CHICKEN_VARIANT,
        RESOLVABLE_PROFILE;

    }
}

