/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.libs.lamp.util;

import com.artillexstudios.axtrade.libs.lamp.core.BaseCommandDispatcher;
import com.artillexstudios.axtrade.libs.lamp.core.reflect.MethodCaller;
import com.artillexstudios.axtrade.libs.lamp.util.Collections;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class StackTraceSanitizer {
    private static final StackTraceSanitizer DEFAULT_SANITIZER = StackTraceSanitizer.builder().ignoreClasses(BaseCommandDispatcher.class).ignoreClasses(MethodHandles.class, MethodHandle.class).ignorePackage(MethodCaller.class.getPackage()).build();
    private static final StackTraceSanitizer EMPTY = new StackTraceSanitizer(java.util.Collections.emptyList());
    private final @Unmodifiable List<Predicate<StackTraceElement>> filters;

    public void sanitize(@NotNull Throwable throwable) {
        if (this.filters.isEmpty()) {
            return;
        }
        if (throwable.getCause() != null) {
            this.sanitize(throwable.getCause());
        }
        List<StackTraceElement> trace = Collections.listOf(throwable.getStackTrace());
        int stripIndex = trace.size();
        for (int i = 0; i < trace.size(); ++i) {
            StackTraceElement stackTraceElement = trace.get(i);
            if (!this.filters.stream().anyMatch(f -> f.test(stackTraceElement))) continue;
            stripIndex = i;
            break;
        }
        trace.subList(stripIndex, trace.size()).clear();
        throwable.setStackTrace(trace.toArray(new StackTraceElement[0]));
    }

    private StackTraceSanitizer(@Unmodifiable List<Predicate<StackTraceElement>> filters) {
        this.filters = filters;
    }

    public static StackTraceSanitizer defaultSanitizer() {
        return DEFAULT_SANITIZER;
    }

    public static StackTraceSanitizer empty() {
        return EMPTY;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Predicate<StackTraceElement>> filters = new ArrayList<Predicate<StackTraceElement>>();

        public Builder ignoreClasses(Class<?> ... classes) {
            for (Class<?> clazz : classes) {
                this.filters.add(c2 -> c2.getClassName().equals(clazz.getName()));
            }
            return this;
        }

        public Builder ignorePackage(@NotNull String packageName) {
            this.filters.add(c2 -> c2.getClassName().startsWith(packageName));
            return this;
        }

        public Builder ignorePackage(@NotNull Package pkg) {
            this.filters.add(c2 -> c2.getClassName().startsWith(pkg.getName()));
            return this;
        }

        public Builder ignoreMethod(@NotNull String methodName) {
            this.filters.add(c2 -> c2.getMethodName().equals(methodName));
            return this;
        }

        public Builder ignoreNativeMethods() {
            this.filters.add(StackTraceElement::isNativeMethod);
            return this;
        }

        public StackTraceSanitizer build() {
            return new StackTraceSanitizer(java.util.Collections.unmodifiableList(new ArrayList<Predicate<StackTraceElement>>(this.filters)));
        }
    }
}

