/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.utils;

import com.artillexstudios.axtrade.hooks.currency.CurrencyHook;

public class TaxUtils {
    public static double getTotalAfterTax(double original, CurrencyHook currencyHook) {
        Number tax = TaxUtils.getTaxPercent(currencyHook);
        double taxMulti = TaxUtils.getMultiplierFormat(tax.doubleValue());
        if (taxMulti == 1.0) {
            return original;
        }
        return TaxUtils.floorIfUnsupported(original * taxMulti, currencyHook);
    }

    public static double getTotalTax(double original, CurrencyHook currencyHook) {
        Number tax = TaxUtils.getTaxPercent(currencyHook);
        double taxMulti = TaxUtils.getMultiplierFormat(tax.doubleValue());
        if (taxMulti == 1.0) {
            return 0.0;
        }
        return TaxUtils.ceilIfUnsupported(original - original * taxMulti, currencyHook);
    }

    public static Number getTaxPercent(CurrencyHook currencyHook) {
        Number value = (Number)currencyHook.getSettings().getOrDefault("tax", 0);
        return Math.min(value.doubleValue(), 99.0);
    }

    public static double getMultiplierFormat(double original) {
        return (100.0 - original) / 100.0;
    }

    private static double floorIfUnsupported(double amount, CurrencyHook currencyHook) {
        if (currencyHook.usesDouble()) {
            return amount;
        }
        return Math.floor(amount);
    }

    private static double ceilIfUnsupported(double amount, CurrencyHook currencyHook) {
        if (currencyHook.usesDouble()) {
            return amount;
        }
        return Math.ceil(amount);
    }
}

