/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.zapper.remapper;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.bukkit.Bukkit;
import org.bukkit.plugin.PluginDescriptionFile;

public final class PaperLibraryRemapper {
    private static final Function<Path, Path> remapperFunction;

    public static File tryRemap(PluginDescriptionFile pdf, File file, boolean isRemap) {
        if (!isRemap) {
            return file;
        }
        Path path = file.toPath();
        File out = new File(file.getParentFile(), file.getName() + ".tmp");
        try (JarFile jarFile = new JarFile(file);
             JarOutputStream tempJar = new JarOutputStream(Files.newOutputStream(out.toPath(), new OpenOption[0]));){
            jarFile.stream().forEach(entry -> {
                byte[] classBytes;
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) {
                    try {
                        byte[] bytes;
                        tempJar.putNextEntry(new JarEntry(entry.getName()));
                        try (InputStream is = jarFile.getInputStream((ZipEntry)entry);){
                            bytes = ByteStreams.toByteArray((InputStream)is);
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                        tempJar.write(bytes);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                    return;
                }
                try {
                    byte[] bytes;
                    try (InputStream is = jarFile.getInputStream((ZipEntry)entry);){
                        bytes = classBytes = ByteStreams.toByteArray((InputStream)is);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                    try {
                        classBytes = Bukkit.getServer().getUnsafe().processClass(pdf, entry.getName(), classBytes);
                    }
                    catch (NullPointerException exception) {
                        classBytes = bytes;
                    }
                }
                catch (Exception exception) {
                    try (InputStream is = jarFile.getInputStream((ZipEntry)entry);){
                        classBytes = ByteStreams.toByteArray((InputStream)is);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                try {
                    tempJar.putNextEntry(new JarEntry(entry.getName()));
                    tempJar.write(classBytes);
                    tempJar.closeEntry();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            Files.move(out.toPath(), path, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AtomicMoveNotSupportedException exception) {
            try {
                Files.move(out.toPath(), path, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return remapperFunction.apply(path).toFile();
    }

    static {
        Function<Object, Object> remapperFunction1;
        try {
            Class<?> PLUGIN_INITIALIZE_MANAGER = Class.forName("io.papermc.paper.plugin.PluginInitializerManager");
            Field IMPL_FIELD = PLUGIN_INITIALIZE_MANAGER.getDeclaredField("impl");
            IMPL_FIELD.setAccessible(true);
            Object PLUGIN_INITIALIZE_MANAGER_INSTANCE = IMPL_FIELD.get(null);
            Field REMAPPER_FIELD = PLUGIN_INITIALIZE_MANAGER.getDeclaredField("pluginRemapper");
            Object REMAPPER_INSTANCE = REMAPPER_FIELD.get(PLUGIN_INITIALIZE_MANAGER_INSTANCE);
            if (REMAPPER_INSTANCE == null) {
                remapperFunction1 = Function.identity();
            } else {
                Method REWRITE_METHOD = REMAPPER_INSTANCE.getClass().getDeclaredMethod("rewritePlugin", Path.class);
                remapperFunction1 = path -> {
                    try {
                        return (Path)REWRITE_METHOD.invoke(REMAPPER_INSTANCE, path);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                };
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException exception) {
            remapperFunction1 = Function.identity();
        }
        remapperFunction = remapperFunction1;
    }
}

