/*
 * Decompiled with CFR 0.152.
 */
package magicbook.morfonica.api.creativetab;

import java.util.function.Supplier;
import magicbook.morfonica.MonicaMod;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BaseCreativeTab
extends CreativeTabs {
    private final boolean hasSearchBar;
    private final Supplier<ItemStack> iconSupplier;

    public BaseCreativeTab(String tabName, Supplier<ItemStack> iconSupplier, boolean hasSearchBar) {
        super(tabName);
        this.iconSupplier = iconSupplier;
        this.hasSearchBar = hasSearchBar;
        if (hasSearchBar) {
            this.setBackgroundImageName("item_search.png");
        }
    }

    @NotNull
    public ItemStack createIcon() {
        if (this.iconSupplier == null) {
            MonicaMod.logger.error("Icon supplier was null for CreativeTab {}", (Object)this.getTabLabel());
            return new ItemStack(Blocks.STONE);
        }
        ItemStack stack = this.iconSupplier.get();
        if (stack == null) {
            MonicaMod.logger.error("Icon supplier return null for CreativeTab {}", (Object)this.getTabLabel());
            return new ItemStack(Blocks.STONE);
        }
        if (stack.isEmpty()) {
            MonicaMod.logger.error("Icon built from iconSupplied is EMPTY for CreativeTab {}", (Object)this.getTabLabel());
            return new ItemStack(Blocks.STONE);
        }
        return stack;
    }

    public boolean hasSearchBar() {
        return this.hasSearchBar;
    }
}

