/*
 * Decompiled with CFR 0.152.
 */
package magicbook.morfonica.common;

import java.util.function.Function;
import magicbook.morfonica.MonicaMod;
import magicbook.morfonica.common.block.MonicaBlocks;
import magicbook.morfonica.loader.MonicaRecipes;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="morfonica")
public class CommonProxy {
    @SubscribeEvent
    public static void syncConfigValues(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("morfonica")) {
            ConfigManager.sync((String)"morfonica", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        MonicaMod.logger.debug("Starting to Register Blocks...");
        registry.register((IForgeRegistryEntry)MonicaBlocks.MASHIRO_DOLL);
        registry.register((IForgeRegistryEntry)MonicaBlocks.TSUKUSHI_DOLL);
        registry.register((IForgeRegistryEntry)MonicaBlocks.NANAMI_DOLL);
        registry.register((IForgeRegistryEntry)MonicaBlocks.TOKO_DOLL);
        registry.register((IForgeRegistryEntry)MonicaBlocks.RUI_DOLL);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        MonicaMod.logger.debug("Starting to Register Items...");
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MonicaBlocks.MASHIRO_DOLL, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MonicaBlocks.TSUKUSHI_DOLL, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MonicaBlocks.NANAMI_DOLL, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MonicaBlocks.TOKO_DOLL, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MonicaBlocks.RUI_DOLL, ItemBlock::new));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        MonicaMod.logger.debug("Starting to Register Recipes...");
        MonicaRecipes.init();
    }

    private static <T extends Block> ItemBlock createItemBlock(T block, Function<T, ItemBlock> producer) {
        ItemBlock itemBlock = producer.apply(block);
        ResourceLocation registryName = block.getRegistryName();
        if (registryName == null) {
            throw new IllegalArgumentException("Block " + block.getTranslationKey() + " has no registry name");
        }
        itemBlock.setRegistryName(registryName);
        return itemBlock;
    }
}

