package magicbook.morfonica;

import magicbook.morfonica.api.MonicaTags;
import magicbook.morfonica.common.CommonProxy;
import magicbook.morfonica.common.block.MonicaBlocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid = MonicaTags.MOD_ID,
     name = MonicaTags.MOD_NAME,
     version = MonicaTags.VERSION,
     acceptedMinecraftVersions = "[1.12.2]")
public class MonicaMod
{

    public static Logger logger = LogManager.getLogger(MonicaTags.MOD_NAME);

    @SidedProxy(modId = MonicaTags.MOD_ID,
                clientSide = "magicbook.morfonica.client.ClientProxy",
                serverSide = "magicbook.morfonica.common.CommonProxy")
    public static CommonProxy proxy;

    public static ResourceLocation id()
    {
        return new ResourceLocation(MonicaTags.MOD_ID);
    }

    public static ResourceLocation id(String path)
    {
        return new ResourceLocation(MonicaTags.MOD_ID, path);
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event)
    {
        logger.debug("Starting to Pre-Initialized Blocks...");
        MonicaBlocks.init();
    }


}
