package magicbook.morfonica.common;

import magicbook.morfonica.MonicaMod;
import magicbook.morfonica.api.MonicaTags;
import magicbook.morfonica.common.block.MonicaBlocks;
import magicbook.morfonica.loader.MonicaRecipes;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;

import java.util.function.Function;

@Mod.EventBusSubscriber(modid = MonicaTags.MOD_ID)
public class CommonProxy
{

    @SubscribeEvent
    public static void syncConfigValues(ConfigChangedEvent.OnConfigChangedEvent event)
    {
        if (event.getModID().equals(MonicaTags.MOD_ID))
        {
            ConfigManager.sync(MonicaTags.MOD_ID, Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event)
    {
        IForgeRegistry<Block> registry = event.getRegistry();
        MonicaMod.logger.debug("Starting to Register Blocks...");
        registry.register(MonicaBlocks.MASHIRO_DOLL);
        registry.register(MonicaBlocks.TSUKUSHI_DOLL);
        registry.register(MonicaBlocks.NANAMI_DOLL);
        registry.register(MonicaBlocks.TOKO_DOLL);
        registry.register(MonicaBlocks.RUI_DOLL);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event)
    {
        IForgeRegistry<Item> registry = event.getRegistry();
        MonicaMod.logger.debug("Starting to Register Items...");
        registry.register(createItemBlock(MonicaBlocks.MASHIRO_DOLL, ItemBlock::new));
        registry.register(createItemBlock(MonicaBlocks.TSUKUSHI_DOLL, ItemBlock::new));
        registry.register(createItemBlock(MonicaBlocks.NANAMI_DOLL, ItemBlock::new));
        registry.register(createItemBlock(MonicaBlocks.TOKO_DOLL, ItemBlock::new));
        registry.register(createItemBlock(MonicaBlocks.RUI_DOLL, ItemBlock::new));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event)
    {
        MonicaMod.logger.debug("Starting to Register Recipes...");
        MonicaRecipes.init();
    }

    private static <T extends Block> ItemBlock createItemBlock(T block,
                                                               Function<T, ItemBlock> producer)
    {
        ItemBlock itemBlock = producer.apply(block);
        ResourceLocation registryName = block.getRegistryName();
        if (registryName == null)
        {
            throw new IllegalArgumentException("Block " + block.getTranslationKey() + " has no registry name");
        }
        itemBlock.setRegistryName(registryName);
        return itemBlock;
    }

}
