package magicbook.morfonica.common.block;

import magicbook.morfonica.common.block.blocks.BlockMashiroDoll;
import magicbook.morfonica.common.block.blocks.BlockNanamiDoll;
import magicbook.morfonica.common.block.blocks.BlockRuiDoll;
import magicbook.morfonica.common.block.blocks.BlockTokoDoll;
import magicbook.morfonica.common.block.blocks.BlockTsukushiDoll;
import magicbook.morfonica.common.creativetab.MonicaCreativeTabs;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.Objects;

public class MonicaBlocks
{

    public static BlockMashiroDoll MASHIRO_DOLL;
    public static BlockTsukushiDoll TSUKUSHI_DOLL;
    public static BlockNanamiDoll NANAMI_DOLL;
    public static BlockTokoDoll TOKO_DOLL;
    public static BlockRuiDoll RUI_DOLL;

    public static void init()
    {
        MASHIRO_DOLL = new BlockMashiroDoll();
        MASHIRO_DOLL.setRegistryName("doll_msr");
        MASHIRO_DOLL.setTranslationKey("mashiro_doll");
        MASHIRO_DOLL.setCreativeTab(MonicaCreativeTabs.TAB_MONICA);

        TSUKUSHI_DOLL = new BlockTsukushiDoll();
        TSUKUSHI_DOLL.setRegistryName("doll_tks");
        TSUKUSHI_DOLL.setTranslationKey("tsukushi_doll");
        TSUKUSHI_DOLL.setCreativeTab(MonicaCreativeTabs.TAB_MONICA);

        NANAMI_DOLL = new BlockNanamiDoll();
        NANAMI_DOLL.setRegistryName("doll_nnm");
        NANAMI_DOLL.setTranslationKey("nanami_doll");
        NANAMI_DOLL.setCreativeTab(MonicaCreativeTabs.TAB_MONICA);

        TOKO_DOLL = new BlockTokoDoll();
        TOKO_DOLL.setRegistryName("doll_toko");
        TOKO_DOLL.setTranslationKey("toko_doll");
        TOKO_DOLL.setCreativeTab(MonicaCreativeTabs.TAB_MONICA);

        RUI_DOLL = new BlockRuiDoll();
        RUI_DOLL.setRegistryName("doll_rui");
        RUI_DOLL.setTranslationKey("rui_doll");
        RUI_DOLL.setCreativeTab(MonicaCreativeTabs.TAB_MONICA);
    }

    @SideOnly(Side.CLIENT)
    public static void registerItemModels()
    {
        ModelLoader.setCustomModelResourceLocation(Item.getItemFromBlock(MASHIRO_DOLL), 0,
                new ModelResourceLocation(Objects.requireNonNull(MASHIRO_DOLL.getRegistryName()), "inventory"));

        ModelLoader.setCustomModelResourceLocation(Item.getItemFromBlock(TSUKUSHI_DOLL), 0,
                new ModelResourceLocation(Objects.requireNonNull(TSUKUSHI_DOLL.getRegistryName()), "inventory"));

        ModelLoader.setCustomModelResourceLocation(Item.getItemFromBlock(NANAMI_DOLL), 0,
                new ModelResourceLocation(Objects.requireNonNull(NANAMI_DOLL.getRegistryName()), "inventory"));

        ModelLoader.setCustomModelResourceLocation(Item.getItemFromBlock(TOKO_DOLL), 0,
                new ModelResourceLocation(Objects.requireNonNull(TOKO_DOLL.getRegistryName()), "inventory"));

        ModelLoader.setCustomModelResourceLocation(Item.getItemFromBlock(RUI_DOLL), 0,
                new ModelResourceLocation(Objects.requireNonNull(RUI_DOLL.getRegistryName()), "inventory"));
    }

}
