package magicbook.morfonica.loader;

import magicbook.morfonica.MonicaMod;
import magicbook.morfonica.common.MonicaConfigHolder;
import magicbook.morfonica.common.block.MonicaBlocks;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class MonicaRecipes
{

    public static void init()
    {
        if (!MonicaConfigHolder.disabledDollRecipes)
        {
            // Mashiro Doll
            GameRegistry.addShapedRecipe(MonicaMod.id("mashiro_doll"), MonicaMod.id(),
                    new ItemStack(MonicaBlocks.MASHIRO_DOLL),
                    "DSD", "SBS", "DSD",
                    'B', new ItemStack(Blocks.SNOW),
                    'D', new ItemStack(Blocks.STONE, 1, 3),
                    'S', new ItemStack(Items.SUGAR));

            // Tsukushi Doll
            GameRegistry.addShapedRecipe(MonicaMod.id("tsukushi_doll"), MonicaMod.id(),
                    new ItemStack(MonicaBlocks.TSUKUSHI_DOLL),
                    "FCF", "DBD", "DBD",
                    'B', new ItemStack(Items.BOOK),
                    'C', new ItemStack(Items.COOKIE),
                    'D', new ItemStack(Blocks.DIRT),
                    'F', new ItemStack(Blocks.RED_FLOWER, 1, 5));

            // Nanami Doll
            GameRegistry.addShapedRecipe(MonicaMod.id("nanami_doll"), MonicaMod.id(),
                    new ItemStack(MonicaBlocks.NANAMI_DOLL),
                    "FGF", "FCF", "FPF",
                    'C', new ItemStack(Items.CAKE),
                    'F', new ItemStack(Items.FEATHER),
                    'G', new ItemStack(Items.GHAST_TEAR),
                    'P', new ItemStack(Items.PAINTING));

            // Toko Doll
            GameRegistry.addShapedRecipe(MonicaMod.id("toko_doll"), MonicaMod.id(),
                    new ItemStack(MonicaBlocks.TOKO_DOLL),
                    "LRL", "FGF", "LRL",
                    'F', new ItemStack(Items.FIRE_CHARGE),
                    'G', new ItemStack(Items.GOLD_INGOT),
                    'L', new ItemStack(Items.LEATHER),
                    'R', new ItemStack(Items.REDSTONE));

            // Rui Doll
            GameRegistry.addShapedRecipe(MonicaMod.id("rui_doll"), MonicaMod.id(),
                    new ItemStack(MonicaBlocks.RUI_DOLL),
                    "GBG", "INI", "GBG",
                    'B', new ItemStack(Blocks.IRON_BARS),
                    'G', new ItemStack(Items.GLOWSTONE_DUST),
                    'N', new ItemStack(Blocks.NOTEBLOCK),
                    'I', new ItemStack(Items.IRON_INGOT));
        }

    }

}
