/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.the_last_sword.compat.CompatCheck;
import net.the_last_sword.configuration.TheLastSwordConfigManager;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.init.TheLastSwordModAttributes;
import net.the_last_sword.init.TheLastSwordModBlockEntities;
import net.the_last_sword.init.TheLastSwordModBlocks;
import net.the_last_sword.init.TheLastSwordModEntities;
import net.the_last_sword.init.TheLastSwordModItems;
import net.the_last_sword.init.TheLastSwordModMenus;
import net.the_last_sword.init.TheLastSwordModMobEffects;
import net.the_last_sword.init.TheLastSwordModSounds;
import net.the_last_sword.init.TheLastSwordModTabs;
import net.the_last_sword.network.ChangeModeMessage;
import net.the_last_sword.network.ConfigRecipeSyncPacket;
import net.the_last_sword.network.JEISyncPacket;
import net.the_last_sword.network.OpenSummonWraithMessage;
import net.the_last_sword.recipe.ConfigDragonCrystalSmithingManager;
import net.the_last_sword.recipe.DragonCrystalSmithingRecipe;
import net.the_last_sword.recipe.DragonCrystalSmithingSerializer;
import net.the_last_sword.recipe.DragonCrystalSmithingType;
import net.the_last_sword.util.TheLastSwordLogger;

@Mod(value="the_last_sword")
public class TheLastSwordMod {
    public static final String MODID = "the_last_sword";
    public static final ResourceLocation DRAGON_CRYSTAL_SMITHING_ID = new ResourceLocation("the_last_sword", "dragon_crystal_smithing");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"the_last_sword");
    public static final RegistryObject<RecipeSerializer<?>> DRAGON_CRYSTAL_SMITHING_SERIALIZER = RECIPE_SERIALIZERS.register(DRAGON_CRYSTAL_SMITHING_ID.m_135815_(), () -> DragonCrystalSmithingSerializer.INSTANCE);
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"the_last_sword");
    public static final RegistryObject<RecipeType<DragonCrystalSmithingRecipe>> DRAGON_CRYSTAL_SMITHING = RECIPE_TYPES.register(DRAGON_CRYSTAL_SMITHING_ID.m_135815_(), () -> DragonCrystalSmithingType.INSTANCE);
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("the_last_sword", "the_last_sword"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public TheLastSwordMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        TheLastSwordModAttributes.REGISTRY.register(bus);
        TheLastSwordModBlocks.REGISTRY.register(bus);
        TheLastSwordModBlockEntities.REGISTRY.register(bus);
        TheLastSwordModItems.REGISTRY.register(bus);
        TheLastSwordModEntities.REGISTRY.register(bus);
        TheLastSwordModMobEffects.register(bus);
        TheLastSwordModTabs.REGISTRY.register(bus);
        TheLastSwordModMenus.REGISTRY.register(bus);
        TheLastSwordModSounds.REGISTRY.register(bus);
        RECIPE_SERIALIZERS.register(bus);
        RECIPE_TYPES.register(bus);
        TheLastSwordConfigManager.initializeConfig();
        ConfigDragonCrystalSmithingManager.reloadRecipes();
        this.init();
    }

    private void init() {
        TheLastSwordMod.addNetworkMessage(ChangeModeMessage.class, ChangeModeMessage::buffer, ChangeModeMessage::new, ChangeModeMessage::handler);
        TheLastSwordMod.addNetworkMessage(ConfigSyncPacket.class, ConfigSyncPacket::encode, ConfigSyncPacket::new, ConfigSyncPacket::handle);
        TheLastSwordMod.addNetworkMessage(ConfigRecipeSyncPacket.class, ConfigRecipeSyncPacket::encode, ConfigRecipeSyncPacket::decode, ConfigRecipeSyncPacket::handle);
        TheLastSwordMod.addNetworkMessage(OpenSummonWraithMessage.class, OpenSummonWraithMessage::buffer, OpenSummonWraithMessage::new, OpenSummonWraithMessage::handler);
        if (CompatCheck.isJEILoadedEarly()) {
            JEISyncPacket.registerMessage(null);
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigReload);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }

    public void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == TheLastSwordConfiguration.SPEC) {
            if (this.isServerSideConfigChange()) {
                TheLastSwordLogger.info("Server configuration reloaded, syncing to all clients...");
                TheLastSwordMod.syncConfigToAllClients();
            } else {
                TheLastSwordLogger.info("Client configuration reloaded locally, no sync to other players.");
            }
        }
    }

    private boolean isServerSideConfigChange() {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return true;
        }
        if (FMLEnvironment.dist.isClient()) {
            return this.isLocalServerHost();
        }
        return false;
    }

    private boolean isLocalServerHost() {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return false;
            }
            if (!server.m_6982_()) {
                boolean isServerThread;
                Thread currentThread = Thread.currentThread();
                boolean bl = isServerThread = currentThread.getThreadGroup() == SidedThreadGroups.SERVER;
                if (isServerThread) {
                    TheLastSwordLogger.info("Configuration change detected from local server host");
                    return true;
                }
                TheLastSwordLogger.info("Configuration change detected from client side, not server host");
                return false;
            }
            return false;
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Error checking server host status", e);
            return false;
        }
    }

    public static void syncConfigToAllClients() {
        if (!TheLastSwordMod.isServerEnvironment()) {
            TheLastSwordLogger.warn("Attempted to sync config from non-server environment - blocked for security!");
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            ConfigSyncPacket packet = new ConfigSyncPacket();
            int syncedPlayers = 0;
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
                ++syncedPlayers;
            }
            TheLastSwordLogger.info("Server configuration synced to {} players", syncedPlayers);
        } else {
            TheLastSwordLogger.error("Cannot sync config - server instance not available");
        }
    }

    private static boolean isServerEnvironment() {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return true;
        }
        if (FMLEnvironment.dist.isClient()) {
            return TheLastSwordMod.isStaticLocalServerHost();
        }
        return false;
    }

    private static boolean isStaticLocalServerHost() {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return false;
            }
            if (!server.m_6982_()) {
                boolean isServerThread;
                Thread currentThread = Thread.currentThread();
                boolean bl = isServerThread = currentThread.getThreadGroup() == SidedThreadGroups.SERVER;
                if (isServerThread) {
                    TheLastSwordLogger.info("Server operation authorized from local server host");
                    return true;
                }
                TheLastSwordLogger.info("Server operation blocked - not from server host");
                return false;
            }
            return false;
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Error checking static server host status", e);
            return false;
        }
    }

    public static void syncConfigToPlayer(ServerPlayer player) {
        if (!TheLastSwordMod.isServerEnvironment()) {
            TheLastSwordLogger.warn("Attempted to sync config to player from non-server environment - blocked for security!");
            return;
        }
        if (player != null) {
            ConfigSyncPacket packet = new ConfigSyncPacket();
            PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
            TheLastSwordLogger.info("Server configuration synced to player {}", player.m_7755_().getString());
        } else {
            TheLastSwordLogger.error("Cannot sync config to null player");
        }
    }

    public static class ConfigSyncPacket {
        private final boolean enableUnsafeCode;
        private final boolean enableStrongDefence;
        private final double increaseValue;
        private final double increaseValueHighLevel;
        private final boolean allowFlying;
        private final boolean attackVillagers;
        private final boolean attackAnimals;
        private final boolean attackTamed;
        private final boolean attackPlayers;
        private final boolean attackGolems;
        private final boolean attackNeutral;
        private final double absoluteDestructionMultiplier;
        private final double shieldMultiplier;
        private final boolean blockCancelUse;
        private final boolean superDestroy;
        private final int miningRadius;
        private final double armorLevelArmorIncrease;
        private final double armorLevelToughnessIncrease;
        private final double armorLevelHealthIncrease;
        private final boolean enableNightVision;
        private final int justifiedDefenceTick;
        private final double armorLevelJustifiedDefenceIncrease;
        private final double customHealthDamageReduction;
        private final double maxDamagePerHit;
        private final boolean enableAllThingsEnd;
        private final boolean enableBattleMusic;
        private final double swordWraithHealthPerLevel;
        private final double swordWraithAttackPerLevel;
        private final double swordWraithHealthPerHighLevel;
        private final double swordWraithAttackPerHighLevel;
        private final boolean voidEnchantmentParticleEffects;
        private final double voidEnchantmentDamagePercentage;
        private final boolean dropDragonEgg;
        private final boolean multipleDragonEggs;
        private final int dragonEggRadius;
        private final int dragonEggAmount;
        private final boolean giveEggToAbsentPlayers;
        private final int maxDragonLevel;
        private final double dragonHealthIncreaseValue;
        private final double dragonHealthIncreaseValueHighLevel;
        private final double dragonArmorIncreaseValue;
        private final double dragonArmorIncreaseValueHighLevel;
        private final double dragonAttackIncreaseValue;
        private final double dragonAttackIncreaseValueHighLevel;
        private final boolean healNegation;
        private final int reviveBanTime;
        private final boolean dieMessage;

        public ConfigSyncPacket() {
            this.enableUnsafeCode = (Boolean)TheLastSwordConfiguration.ENABLE_UNSAFE_CODE.get();
            this.enableStrongDefence = (Boolean)TheLastSwordConfiguration.ENABLE_RADICAL_LOGIC.get();
            this.increaseValue = (Double)TheLastSwordConfiguration.INCREASE_VALUE.get();
            this.increaseValueHighLevel = (Double)TheLastSwordConfiguration.INCREASE_VALUE_HIGH_LEVEL.get();
            this.allowFlying = (Boolean)TheLastSwordConfiguration.ALLOW_FLYING.get();
            this.attackVillagers = (Boolean)TheLastSwordConfiguration.ATTACK_VILLAGERS.get();
            this.attackAnimals = (Boolean)TheLastSwordConfiguration.ATTACK_ANIMALS.get();
            this.attackTamed = (Boolean)TheLastSwordConfiguration.ATTACK_TAMED.get();
            this.attackPlayers = (Boolean)TheLastSwordConfiguration.ATTACK_PLAYERS.get();
            this.attackGolems = (Boolean)TheLastSwordConfiguration.ATTACK_GOLEMS.get();
            this.attackNeutral = (Boolean)TheLastSwordConfiguration.ATTACK_NEUTRAL.get();
            this.absoluteDestructionMultiplier = (Double)TheLastSwordConfiguration.ABSOLUTE_DESTRUCTION_MULTIPLIER.get();
            this.shieldMultiplier = (Double)TheLastSwordConfiguration.THE_LAST_END_SWORD_SHIELD_MULTIPLIER.get();
            this.blockCancelUse = (Boolean)TheLastSwordConfiguration.BLOCK_CANCEL_USE.get();
            this.superDestroy = (Boolean)TheLastSwordConfiguration.SUPER_DESTROY.get();
            this.miningRadius = (Integer)TheLastSwordConfiguration.MINING_RADIUS.get();
            this.armorLevelArmorIncrease = (Double)TheLastSwordConfiguration.ARMOR_LEVEL_ARMOR_INCREASE.get();
            this.armorLevelToughnessIncrease = (Double)TheLastSwordConfiguration.ARMOR_LEVEL_TOUGHNESS_INCREASE.get();
            this.armorLevelHealthIncrease = (Double)TheLastSwordConfiguration.ARMOR_LEVEL_HEALTH_INCREASE.get();
            this.enableNightVision = (Boolean)TheLastSwordConfiguration.ENABLE_NIGHT_VISION.get();
            this.justifiedDefenceTick = (Integer)TheLastSwordConfiguration.JUSTIFIED_DEFENCE_TICK.get();
            this.armorLevelJustifiedDefenceIncrease = (Double)TheLastSwordConfiguration.ARMOR_LEVEL_JUSTIFIED_DEFENCE_INCREASE.get();
            this.customHealthDamageReduction = (Double)TheLastSwordConfiguration.CUSTOM_HEALTH_DAMAGE_REDUCTION.get();
            this.maxDamagePerHit = (Double)TheLastSwordConfiguration.MAX_DAMAGE_PER_HIT.get();
            this.enableAllThingsEnd = (Boolean)TheLastSwordConfiguration.ENABLE_ALL_THINGS_END.get();
            this.enableBattleMusic = (Boolean)TheLastSwordConfiguration.ENABLE_BATTLE_MUSIC.get();
            this.swordWraithHealthPerLevel = (Double)TheLastSwordConfiguration.SWORD_WRAITH_HEALTH_PER_LEVEL.get();
            this.swordWraithAttackPerLevel = (Double)TheLastSwordConfiguration.SWORD_WRAITH_ATTACK_PER_LEVEL.get();
            this.swordWraithHealthPerHighLevel = (Double)TheLastSwordConfiguration.SWORD_WRAITH_HEALTH_PER_HIGH_LEVEL.get();
            this.swordWraithAttackPerHighLevel = (Double)TheLastSwordConfiguration.SWORD_WRAITH_ATTACK_PER_HIGH_LEVEL.get();
            this.voidEnchantmentParticleEffects = (Boolean)TheLastSwordConfiguration.VOID_ENCHANTMENT_PARTICLE_EFFECTS.get();
            this.voidEnchantmentDamagePercentage = (Double)TheLastSwordConfiguration.VOID_ENCHANTMENT_DAMAGE_PERCENTAGE.get();
            this.dropDragonEgg = (Boolean)TheLastSwordConfiguration.DROP_DRAGON_EGG.get();
            this.multipleDragonEggs = (Boolean)TheLastSwordConfiguration.MULTIPLE_DRAGON_EGGS.get();
            this.dragonEggRadius = (Integer)TheLastSwordConfiguration.DRAGON_EGG_RADIUS.get();
            this.dragonEggAmount = (Integer)TheLastSwordConfiguration.DRAGON_EGG_AMOUNT.get();
            this.giveEggToAbsentPlayers = (Boolean)TheLastSwordConfiguration.GIVE_EGG_TO_ABSENT_PLAYERS.get();
            this.maxDragonLevel = (Integer)TheLastSwordConfiguration.MAX_DRAGON_LEVEL.get();
            this.dragonHealthIncreaseValue = (Double)TheLastSwordConfiguration.DRAGON_HEALTH_INCREASE_VALUE.get();
            this.dragonHealthIncreaseValueHighLevel = (Double)TheLastSwordConfiguration.DRAGON_HEALTH_INCREASE_VALUE_HIGH_LEVEL.get();
            this.dragonArmorIncreaseValue = (Double)TheLastSwordConfiguration.DRAGON_ARMOR_INCREASE_VALUE.get();
            this.dragonArmorIncreaseValueHighLevel = (Double)TheLastSwordConfiguration.DRAGON_ARMOR_INCREASE_VALUE_HIGH_LEVEL.get();
            this.dragonAttackIncreaseValue = (Double)TheLastSwordConfiguration.DRAGON_ATTACK_INCREASE_VALUE.get();
            this.dragonAttackIncreaseValueHighLevel = (Double)TheLastSwordConfiguration.DRAGON_ATTACK_INCREASE_VALUE_HIGH_LEVEL.get();
            this.healNegation = (Boolean)TheLastSwordConfiguration.HEAL_NEGATION.get();
            this.reviveBanTime = (Integer)TheLastSwordConfiguration.REVIVE_BAN_TIME.get();
            this.dieMessage = (Boolean)TheLastSwordConfiguration.DIE_MESSAGE.get();
        }

        public ConfigSyncPacket(FriendlyByteBuf buffer) {
            this.enableUnsafeCode = buffer.readBoolean();
            this.enableStrongDefence = buffer.readBoolean();
            this.increaseValue = buffer.readDouble();
            this.increaseValueHighLevel = buffer.readDouble();
            this.allowFlying = buffer.readBoolean();
            this.attackVillagers = buffer.readBoolean();
            this.attackAnimals = buffer.readBoolean();
            this.attackTamed = buffer.readBoolean();
            this.attackPlayers = buffer.readBoolean();
            this.attackGolems = buffer.readBoolean();
            this.attackNeutral = buffer.readBoolean();
            this.absoluteDestructionMultiplier = buffer.readDouble();
            this.shieldMultiplier = buffer.readDouble();
            this.blockCancelUse = buffer.readBoolean();
            this.superDestroy = buffer.readBoolean();
            this.miningRadius = buffer.readInt();
            this.armorLevelArmorIncrease = buffer.readDouble();
            this.armorLevelToughnessIncrease = buffer.readDouble();
            this.armorLevelHealthIncrease = buffer.readDouble();
            this.enableNightVision = buffer.readBoolean();
            this.justifiedDefenceTick = buffer.readInt();
            this.armorLevelJustifiedDefenceIncrease = buffer.readDouble();
            this.customHealthDamageReduction = buffer.readDouble();
            this.maxDamagePerHit = buffer.readDouble();
            this.enableAllThingsEnd = buffer.readBoolean();
            this.enableBattleMusic = buffer.readBoolean();
            this.swordWraithHealthPerLevel = buffer.readDouble();
            this.swordWraithAttackPerLevel = buffer.readDouble();
            this.swordWraithHealthPerHighLevel = buffer.readDouble();
            this.swordWraithAttackPerHighLevel = buffer.readDouble();
            this.voidEnchantmentParticleEffects = buffer.readBoolean();
            this.voidEnchantmentDamagePercentage = buffer.readDouble();
            this.dropDragonEgg = buffer.readBoolean();
            this.multipleDragonEggs = buffer.readBoolean();
            this.dragonEggRadius = buffer.readInt();
            this.dragonEggAmount = buffer.readInt();
            this.giveEggToAbsentPlayers = buffer.readBoolean();
            this.maxDragonLevel = buffer.readInt();
            this.dragonHealthIncreaseValue = buffer.readDouble();
            this.dragonHealthIncreaseValueHighLevel = buffer.readDouble();
            this.dragonArmorIncreaseValue = buffer.readDouble();
            this.dragonArmorIncreaseValueHighLevel = buffer.readDouble();
            this.dragonAttackIncreaseValue = buffer.readDouble();
            this.dragonAttackIncreaseValueHighLevel = buffer.readDouble();
            this.healNegation = buffer.readBoolean();
            this.reviveBanTime = buffer.readInt();
            this.dieMessage = buffer.readBoolean();
        }

        public void encode(FriendlyByteBuf buffer) {
            buffer.writeBoolean(this.enableUnsafeCode);
            buffer.writeBoolean(this.enableStrongDefence);
            buffer.writeDouble(this.increaseValue);
            buffer.writeDouble(this.increaseValueHighLevel);
            buffer.writeBoolean(this.allowFlying);
            buffer.writeBoolean(this.attackVillagers);
            buffer.writeBoolean(this.attackAnimals);
            buffer.writeBoolean(this.attackTamed);
            buffer.writeBoolean(this.attackPlayers);
            buffer.writeBoolean(this.attackGolems);
            buffer.writeBoolean(this.attackNeutral);
            buffer.writeDouble(this.absoluteDestructionMultiplier);
            buffer.writeDouble(this.shieldMultiplier);
            buffer.writeBoolean(this.blockCancelUse);
            buffer.writeBoolean(this.superDestroy);
            buffer.writeInt(this.miningRadius);
            buffer.writeDouble(this.armorLevelArmorIncrease);
            buffer.writeDouble(this.armorLevelToughnessIncrease);
            buffer.writeDouble(this.armorLevelHealthIncrease);
            buffer.writeBoolean(this.enableNightVision);
            buffer.writeInt(this.justifiedDefenceTick);
            buffer.writeDouble(this.armorLevelJustifiedDefenceIncrease);
            buffer.writeDouble(this.customHealthDamageReduction);
            buffer.writeDouble(this.maxDamagePerHit);
            buffer.writeBoolean(this.enableAllThingsEnd);
            buffer.writeBoolean(this.enableBattleMusic);
            buffer.writeDouble(this.swordWraithHealthPerLevel);
            buffer.writeDouble(this.swordWraithAttackPerLevel);
            buffer.writeDouble(this.swordWraithHealthPerHighLevel);
            buffer.writeDouble(this.swordWraithAttackPerHighLevel);
            buffer.writeBoolean(this.voidEnchantmentParticleEffects);
            buffer.writeDouble(this.voidEnchantmentDamagePercentage);
            buffer.writeBoolean(this.dropDragonEgg);
            buffer.writeBoolean(this.multipleDragonEggs);
            buffer.writeInt(this.dragonEggRadius);
            buffer.writeInt(this.dragonEggAmount);
            buffer.writeBoolean(this.giveEggToAbsentPlayers);
            buffer.writeInt(this.maxDragonLevel);
            buffer.writeDouble(this.dragonHealthIncreaseValue);
            buffer.writeDouble(this.dragonHealthIncreaseValueHighLevel);
            buffer.writeDouble(this.dragonArmorIncreaseValue);
            buffer.writeDouble(this.dragonArmorIncreaseValueHighLevel);
            buffer.writeDouble(this.dragonAttackIncreaseValue);
            buffer.writeDouble(this.dragonAttackIncreaseValueHighLevel);
            buffer.writeBoolean(this.healNegation);
            buffer.writeInt(this.reviveBanTime);
            buffer.writeBoolean(this.dieMessage);
        }

        public void handle(Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                TheLastSwordLogger.info("Received configuration sync from server, updating local values...");
                TheLastSwordConfiguration.ENABLE_UNSAFE_CODE.set((Object)this.enableUnsafeCode);
                TheLastSwordConfiguration.ENABLE_RADICAL_LOGIC.set((Object)this.enableStrongDefence);
                TheLastSwordConfiguration.INCREASE_VALUE.set((Object)this.increaseValue);
                TheLastSwordConfiguration.INCREASE_VALUE_HIGH_LEVEL.set((Object)this.increaseValueHighLevel);
                TheLastSwordConfiguration.ALLOW_FLYING.set((Object)this.allowFlying);
                TheLastSwordConfiguration.ATTACK_VILLAGERS.set((Object)this.attackVillagers);
                TheLastSwordConfiguration.ATTACK_ANIMALS.set((Object)this.attackAnimals);
                TheLastSwordConfiguration.ATTACK_TAMED.set((Object)this.attackTamed);
                TheLastSwordConfiguration.ATTACK_PLAYERS.set((Object)this.attackPlayers);
                TheLastSwordConfiguration.ATTACK_GOLEMS.set((Object)this.attackGolems);
                TheLastSwordConfiguration.ATTACK_NEUTRAL.set((Object)this.attackNeutral);
                TheLastSwordConfiguration.ABSOLUTE_DESTRUCTION_MULTIPLIER.set((Object)this.absoluteDestructionMultiplier);
                TheLastSwordConfiguration.THE_LAST_END_SWORD_SHIELD_MULTIPLIER.set((Object)this.shieldMultiplier);
                TheLastSwordConfiguration.BLOCK_CANCEL_USE.set((Object)this.blockCancelUse);
                TheLastSwordConfiguration.SUPER_DESTROY.set((Object)this.superDestroy);
                TheLastSwordConfiguration.MINING_RADIUS.set((Object)this.miningRadius);
                TheLastSwordConfiguration.ARMOR_LEVEL_ARMOR_INCREASE.set((Object)this.armorLevelArmorIncrease);
                TheLastSwordConfiguration.ARMOR_LEVEL_TOUGHNESS_INCREASE.set((Object)this.armorLevelToughnessIncrease);
                TheLastSwordConfiguration.ARMOR_LEVEL_HEALTH_INCREASE.set((Object)this.armorLevelHealthIncrease);
                TheLastSwordConfiguration.ENABLE_NIGHT_VISION.set((Object)this.enableNightVision);
                TheLastSwordConfiguration.JUSTIFIED_DEFENCE_TICK.set((Object)this.justifiedDefenceTick);
                TheLastSwordConfiguration.ARMOR_LEVEL_JUSTIFIED_DEFENCE_INCREASE.set((Object)this.armorLevelJustifiedDefenceIncrease);
                TheLastSwordConfiguration.CUSTOM_HEALTH_DAMAGE_REDUCTION.set((Object)this.customHealthDamageReduction);
                TheLastSwordConfiguration.MAX_DAMAGE_PER_HIT.set((Object)this.maxDamagePerHit);
                TheLastSwordConfiguration.ENABLE_ALL_THINGS_END.set((Object)this.enableAllThingsEnd);
                TheLastSwordConfiguration.ENABLE_BATTLE_MUSIC.set((Object)this.enableBattleMusic);
                TheLastSwordConfiguration.SWORD_WRAITH_HEALTH_PER_LEVEL.set((Object)this.swordWraithHealthPerLevel);
                TheLastSwordConfiguration.SWORD_WRAITH_ATTACK_PER_LEVEL.set((Object)this.swordWraithAttackPerLevel);
                TheLastSwordConfiguration.SWORD_WRAITH_HEALTH_PER_HIGH_LEVEL.set((Object)this.swordWraithHealthPerHighLevel);
                TheLastSwordConfiguration.SWORD_WRAITH_ATTACK_PER_HIGH_LEVEL.set((Object)this.swordWraithAttackPerHighLevel);
                TheLastSwordConfiguration.VOID_ENCHANTMENT_PARTICLE_EFFECTS.set((Object)this.voidEnchantmentParticleEffects);
                TheLastSwordConfiguration.VOID_ENCHANTMENT_DAMAGE_PERCENTAGE.set((Object)this.voidEnchantmentDamagePercentage);
                TheLastSwordConfiguration.DROP_DRAGON_EGG.set((Object)this.dropDragonEgg);
                TheLastSwordConfiguration.MULTIPLE_DRAGON_EGGS.set((Object)this.multipleDragonEggs);
                TheLastSwordConfiguration.DRAGON_EGG_RADIUS.set((Object)this.dragonEggRadius);
                TheLastSwordConfiguration.DRAGON_EGG_AMOUNT.set((Object)this.dragonEggAmount);
                TheLastSwordConfiguration.GIVE_EGG_TO_ABSENT_PLAYERS.set((Object)this.giveEggToAbsentPlayers);
                TheLastSwordConfiguration.MAX_DRAGON_LEVEL.set((Object)this.maxDragonLevel);
                TheLastSwordConfiguration.DRAGON_HEALTH_INCREASE_VALUE.set((Object)this.dragonHealthIncreaseValue);
                TheLastSwordConfiguration.DRAGON_HEALTH_INCREASE_VALUE_HIGH_LEVEL.set((Object)this.dragonHealthIncreaseValueHighLevel);
                TheLastSwordConfiguration.DRAGON_ARMOR_INCREASE_VALUE.set((Object)this.dragonArmorIncreaseValue);
                TheLastSwordConfiguration.DRAGON_ARMOR_INCREASE_VALUE_HIGH_LEVEL.set((Object)this.dragonArmorIncreaseValueHighLevel);
                TheLastSwordConfiguration.DRAGON_ATTACK_INCREASE_VALUE.set((Object)this.dragonAttackIncreaseValue);
                TheLastSwordConfiguration.DRAGON_ATTACK_INCREASE_VALUE_HIGH_LEVEL.set((Object)this.dragonAttackIncreaseValueHighLevel);
                TheLastSwordConfiguration.HEAL_NEGATION.set((Object)this.healNegation);
                TheLastSwordConfiguration.REVIVE_BAN_TIME.set((Object)this.reviveBanTime);
                TheLastSwordConfiguration.DIE_MESSAGE.set((Object)this.dieMessage);
                TheLastSwordLogger.info("Configuration synchronization completed successfully!");
            });
            context.get().setPacketHandled(true);
        }
    }
}

