/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.attack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.the_last_sword.attack.AttackEffectSavedData;
import net.the_last_sword.configuration.TheLastSwordConfiguration;

public final class AttackEffectManager {
    private static final ConcurrentHashMap<UUID, AttackRecord> RECORDS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, Integer> REVIVE_BAN_TYPES = new ConcurrentHashMap();
    private static volatile boolean needsSave = false;
    private static long lastCleanupTime = 0L;
    private static final long CLEANUP_INTERVAL = 600L;

    public static boolean needsSave() {
        return needsSave;
    }

    public static void markSaved() {
        needsSave = false;
    }

    private static void markDirty() {
        needsSave = true;
    }

    public static void setHealNegation(LivingEntity entity, float controlledHealth) {
        Level level;
        if (entity == null || entity.m_20148_() == null || !((Boolean)TheLastSwordConfiguration.HEAL_NEGATION.get()).booleanValue()) {
            return;
        }
        UUID id = entity.m_20148_();
        AttackRecord record = RECORDS.computeIfAbsent(id, k -> new AttackRecord());
        record.healNegated = true;
        record.healNegationHealth = controlledHealth;
        record.dimension = entity.m_9236_().m_46472_();
        record.entityTypeId = EntityType.m_20613_((EntityType)entity.m_6095_()).toString();
        AttackEffectManager.markDirty();
        if (!entity.m_9236_().f_46443_ && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AttackEffectSavedData.persistData(serverLevel);
        }
    }

    public static boolean isHealNegated(Entity entity) {
        if (entity == null || entity.m_20148_() == null) {
            return false;
        }
        AttackRecord record = RECORDS.get(entity.m_20148_());
        return record != null && record.healNegated;
    }

    public static float getHealNegationHealth(Entity entity) {
        if (entity == null || entity.m_20148_() == null) {
            return 0.0f;
        }
        AttackRecord record = RECORDS.get(entity.m_20148_());
        if (record != null && record.healNegated) {
            return record.healNegationHealth;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living.m_21223_();
        }
        return 0.0f;
    }

    public static void updateHealNegationHealth(Entity entity, float newHealth) {
        if (entity == null || entity.m_20148_() == null) {
            return;
        }
        AttackRecord record = RECORDS.get(entity.m_20148_());
        if (record != null && record.healNegated && newHealth <= record.healNegationHealth) {
            record.healNegationHealth = newHealth;
            AttackEffectManager.markDirty();
        }
    }

    public static void clearHealNegation(Entity entity) {
        if (entity == null || entity.m_20148_() == null) {
            return;
        }
        AttackRecord record = RECORDS.get(entity.m_20148_());
        if (record != null) {
            record.healNegated = false;
            record.healNegationHealth = 0.0f;
            if (!record.hasAnyEffect()) {
                RECORDS.remove(entity.m_20148_());
            }
            AttackEffectManager.markDirty();
        }
    }

    public static void addReviveBan(Entity entity) {
        if (entity == null) {
            return;
        }
        int banTime = TheLastSwordConfiguration.getReviveBanTimeSafely();
        if (banTime <= 0) {
            return;
        }
        Class<?> entityClass = entity.getClass();
        REVIVE_BAN_TYPES.compute(entityClass, (key, existingTime) -> {
            if (existingTime == null || existingTime <= 0) {
                return banTime;
            }
            return existingTime + banTime;
        });
        AttackEffectManager.markDirty();
    }

    public static boolean isReviveBan(Entity entity) {
        if (entity == null) {
            return false;
        }
        Class<?> entityClass = entity.getClass();
        Integer remainingTime = REVIVE_BAN_TYPES.get(entityClass);
        if (remainingTime == null || remainingTime <= 0) {
            if (remainingTime != null) {
                REVIVE_BAN_TYPES.remove(entityClass);
                AttackEffectManager.markDirty();
            }
            return false;
        }
        return true;
    }

    public static void tickReviveBanSystem() {
        if (REVIVE_BAN_TYPES.isEmpty()) {
            return;
        }
        boolean hasChanges = false;
        Iterator<Map.Entry<Class<?>, Integer>> iterator = REVIVE_BAN_TYPES.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Class<?>, Integer> entry = iterator.next();
            int newTime = entry.getValue() - 1;
            if (newTime <= 0) {
                iterator.remove();
                hasChanges = true;
                continue;
            }
            entry.setValue(newTime);
            hasChanges = true;
        }
        if (hasChanges) {
            AttackEffectManager.markDirty();
        }
    }

    public static void worldTick(ServerLevel level) {
        if (level == null) {
            return;
        }
        long currentTime = level.m_46467_();
        if (currentTime - lastCleanupTime >= 600L) {
            AttackEffectManager.cleanupInvalidRecords(level);
            lastCleanupTime = currentTime;
        }
    }

    private static void cleanupInvalidRecords(ServerLevel level) {
        if (RECORDS.isEmpty()) {
            return;
        }
        MinecraftServer server = level.m_7654_();
        int cleanedCount = 0;
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (UUID entityId : RECORDS.keySet()) {
            boolean entityExists = false;
            for (ServerLevel serverLevel : server.m_129785_()) {
                Entity entity = serverLevel.m_8791_(entityId);
                if (!(entity instanceof LivingEntity) || entity.m_213877_()) continue;
                entityExists = true;
                break;
            }
            if (entityExists) continue;
            toRemove.add(entityId);
        }
        for (UUID entityId : toRemove) {
            RECORDS.remove(entityId);
            ++cleanedCount;
        }
        if (cleanedCount > 0) {
            AttackEffectManager.markDirty();
        }
    }

    public static Map<UUID, CompoundTag> exportRecords() {
        HashMap<UUID, CompoundTag> result = new HashMap<UUID, CompoundTag>();
        for (Map.Entry<UUID, AttackRecord> entry : RECORDS.entrySet()) {
            UUID uUID = entry.getKey();
            AttackRecord record = entry.getValue();
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("HealNegated", record.healNegated);
            tag.m_128350_("HealNegationHealth", record.healNegationHealth);
            if (record.dimension != null) {
                tag.m_128359_("Dimension", record.dimension.m_135782_().toString());
            }
            if (record.entityTypeId != null) {
                tag.m_128359_("EntityType", record.entityTypeId);
            }
            tag.m_128356_("LastUpdate", record.lastUpdateTime);
            result.put(uUID, tag);
        }
        CompoundTag reviveBanTag = new CompoundTag();
        for (Map.Entry<Class<?>, Integer> entry : REVIVE_BAN_TYPES.entrySet()) {
            reviveBanTag.m_128405_(entry.getKey().getName(), entry.getValue().intValue());
        }
        if (!reviveBanTag.m_128456_()) {
            UUID uUID = new UUID(0L, 0L);
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128365_("ReviveBanTypes", (Tag)reviveBanTag);
            result.put(uUID, compoundTag);
        }
        return result;
    }

    public static void importRecords(Map<UUID, CompoundTag> data) {
        if (data == null) {
            return;
        }
        REVIVE_BAN_TYPES.clear();
        for (Map.Entry<UUID, CompoundTag> entry : data.entrySet()) {
            UUID entityId = entry.getKey();
            CompoundTag tag = entry.getValue();
            if (entityId == null || tag == null) continue;
            if (entityId.equals(new UUID(0L, 0L))) {
                if (!tag.m_128441_("ReviveBanTypes")) continue;
                CompoundTag reviveBanTag = tag.m_128469_("ReviveBanTypes");
                for (String className : reviveBanTag.m_128431_()) {
                    try {
                        Class<?> clazz = Class.forName(className);
                        int time = reviveBanTag.m_128451_(className);
                        REVIVE_BAN_TYPES.put(clazz, time);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                continue;
            }
            AttackRecord record = new AttackRecord();
            record.healNegated = tag.m_128471_("HealNegated");
            record.healNegationHealth = tag.m_128457_("HealNegationHealth");
            if (tag.m_128441_("Dimension")) {
                ResourceLocation dimLoc = new ResourceLocation(tag.m_128461_("Dimension"));
                record.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimLoc);
            }
            if (tag.m_128441_("EntityType")) {
                record.entityTypeId = tag.m_128461_("EntityType");
            }
            record.lastUpdateTime = tag.m_128454_("LastUpdate");
            if (!record.hasAnyEffect()) continue;
            RECORDS.put(entityId, record);
        }
    }

    public static boolean isTracked(Entity entity) {
        if (entity == null || entity.m_20148_() == null) {
            return false;
        }
        return RECORDS.containsKey(entity.m_20148_());
    }

    public static int getRecordCount() {
        return RECORDS.size();
    }

    public static int getReviveBanTypeCount() {
        return REVIVE_BAN_TYPES.size();
    }

    public static void clearAll(Entity entity) {
        if (entity != null && entity.m_20148_() != null) {
            RECORDS.remove(entity.m_20148_());
            AttackEffectManager.markDirty();
        }
    }

    public static Map<UUID, HealNegationInfo> getAllHealNegationRecords() {
        HashMap<UUID, HealNegationInfo> result = new HashMap<UUID, HealNegationInfo>();
        for (Map.Entry<UUID, AttackRecord> entry : RECORDS.entrySet()) {
            UUID entityId = entry.getKey();
            AttackRecord record = entry.getValue();
            if (!record.healNegated) continue;
            result.put(entityId, new HealNegationInfo(record.healNegationHealth, record.dimension != null ? record.dimension.m_135782_().toString() : "unknown", record.entityTypeId, record.lastUpdateTime));
        }
        return result;
    }

    public static Map<String, ReviveBanInfo> getAllReviveBanTypes() {
        HashMap<String, ReviveBanInfo> result = new HashMap<String, ReviveBanInfo>();
        for (Map.Entry<Class<?>, Integer> entry : REVIVE_BAN_TYPES.entrySet()) {
            Class<?> entityClass = entry.getKey();
            Integer remainingTime = entry.getValue();
            result.put(entityClass.getName(), new ReviveBanInfo(entityClass.getSimpleName(), entityClass.getName(), remainingTime));
        }
        return result;
    }

    public static int clearAllReviveBanTypes() {
        int clearedCount = REVIVE_BAN_TYPES.size();
        REVIVE_BAN_TYPES.clear();
        AttackEffectManager.markDirty();
        return clearedCount;
    }

    public static AttackEffectClearResult clearAllRecords() {
        int healNegationCount = 0;
        int reviveBanCount = REVIVE_BAN_TYPES.size();
        for (AttackRecord record : RECORDS.values()) {
            if (!record.healNegated) continue;
            ++healNegationCount;
        }
        RECORDS.clear();
        REVIVE_BAN_TYPES.clear();
        AttackEffectManager.markDirty();
        return new AttackEffectClearResult(healNegationCount, reviveBanCount);
    }

    public static String getEntityNameByUuid(UUID entityId) {
        if (entityId == null) {
            return "Unknown Entity";
        }
        AttackRecord record = RECORDS.get(entityId);
        if (record != null && record.entityTypeId != null) {
            int lastDot = record.entityTypeId.lastIndexOf(46);
            if (lastDot >= 0) {
                return record.entityTypeId.substring(lastDot + 1);
            }
            return record.entityTypeId;
        }
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                for (ServerLevel level : server.m_129785_()) {
                    Entity entity = level.m_8791_(entityId);
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    return living.m_7755_().getString();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Unknown Entity";
    }

    public static boolean hasHealNegationRecord(UUID entityId) {
        if (entityId == null) {
            return false;
        }
        AttackRecord record = RECORDS.get(entityId);
        return record != null && record.healNegated;
    }

    public static boolean clearRecordByUuid(UUID entityId) {
        if (entityId == null) {
            return false;
        }
        AttackRecord removed = RECORDS.remove(entityId);
        if (removed != null) {
            AttackEffectManager.markDirty();
            return true;
        }
        return false;
    }

    public static boolean updateHealNegationHealthByUuid(UUID entityId, float newHealth) {
        if (entityId == null) {
            return false;
        }
        AttackRecord record = RECORDS.get(entityId);
        if (record != null && record.healNegated) {
            record.healNegationHealth = newHealth;
            record.lastUpdateTime = System.currentTimeMillis();
            AttackEffectManager.markDirty();
            return true;
        }
        return false;
    }

    private AttackEffectManager() {
    }

    private static final class AttackRecord {
        boolean healNegated = false;
        float healNegationHealth = 0.0f;
        ResourceKey<Level> dimension;
        String entityTypeId;
        long lastUpdateTime = System.currentTimeMillis();

        private AttackRecord() {
        }

        boolean hasAnyEffect() {
            return this.healNegated;
        }

        void touch() {
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }

    public static class HealNegationInfo {
        private final float controlledHealth;
        private final String dimensionName;
        private final String entityTypeId;
        private final long lastUpdateTime;

        public HealNegationInfo(float controlledHealth, String dimensionName, String entityTypeId, long lastUpdateTime) {
            this.controlledHealth = controlledHealth;
            this.dimensionName = dimensionName;
            this.entityTypeId = entityTypeId;
            this.lastUpdateTime = lastUpdateTime;
        }

        public float getControlledHealth() {
            return this.controlledHealth;
        }

        public String getDimensionName() {
            if (this.dimensionName != null && this.dimensionName.contains(":")) {
                String[] parts = this.dimensionName.split(":");
                return parts.length > 1 ? parts[1] : this.dimensionName;
            }
            return this.dimensionName != null ? this.dimensionName : "unknown";
        }

        public String getEntityTypeId() {
            return this.entityTypeId;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public String getSimpleEntityType() {
            if (this.entityTypeId != null) {
                int lastDot = this.entityTypeId.lastIndexOf(46);
                return lastDot >= 0 ? this.entityTypeId.substring(lastDot + 1) : this.entityTypeId;
            }
            return "Unknown";
        }
    }

    public static class ReviveBanInfo {
        private final String simpleClassName;
        private final String fullClassName;
        private final int remainingTime;

        public ReviveBanInfo(String simpleClassName, String fullClassName, int remainingTime) {
            this.simpleClassName = simpleClassName;
            this.fullClassName = fullClassName;
            this.remainingTime = remainingTime;
        }

        public String getSimpleClassName() {
            return this.simpleClassName;
        }

        public String getFullClassName() {
            return this.fullClassName;
        }

        public int getRemainingTime() {
            return this.remainingTime;
        }

        public String getFormattedTime() {
            if (this.remainingTime <= 0) {
                return "Expired";
            }
            int hours = this.remainingTime / 3600;
            int minutes = this.remainingTime % 3600 / 60;
            int seconds = this.remainingTime % 60;
            if (hours > 0) {
                return String.format("%dh %dm %ds", hours, minutes, seconds);
            }
            if (minutes > 0) {
                return String.format("%dm %ds", minutes, seconds);
            }
            return String.format("%ds", seconds);
        }
    }

    public static class AttackEffectClearResult {
        private final int healNegationCleared;
        private final int reviveBanCleared;

        public AttackEffectClearResult(int healNegationCleared, int reviveBanCleared) {
            this.healNegationCleared = healNegationCleared;
            this.reviveBanCleared = reviveBanCleared;
        }

        public int getHealNegationCleared() {
            return this.healNegationCleared;
        }

        public int getReviveBanCleared() {
            return this.reviveBanCleared;
        }

        public int getTotalCleared() {
            return this.healNegationCleared + this.reviveBanCleared;
        }
    }
}

