/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.attack;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.the_last_sword.attack.AttackEffectManager;
import net.the_last_sword.util.TheLastSwordLogger;

@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AttackEffectSavedData
extends SavedData {
    private final Map<UUID, CompoundTag> recordsNBT = new HashMap<UUID, CompoundTag>();

    private AttackEffectSavedData() {
    }

    public static AttackEffectSavedData get(ServerLevel level) {
        return (AttackEffectSavedData)level.m_8895_().m_164861_(AttackEffectSavedData::load, AttackEffectSavedData::new, "the_last_sword_attack_effects");
    }

    private static AttackEffectSavedData load(CompoundTag root) {
        AttackEffectSavedData data = new AttackEffectSavedData();
        if (root.m_128441_("AttackRecords")) {
            CompoundTag recordsTag = root.m_128469_("AttackRecords");
            for (String uuidStr : recordsTag.m_128431_()) {
                try {
                    UUID entityId = UUID.fromString(uuidStr);
                    CompoundTag recordTag = recordsTag.m_128469_(uuidStr);
                    data.recordsNBT.put(entityId, recordTag);
                }
                catch (IllegalArgumentException e) {
                    TheLastSwordLogger.error("Invalid UUID in attack effects data: {}", uuidStr);
                }
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag root) {
        CompoundTag recordsTag = new CompoundTag();
        this.recordsNBT.forEach((uuid, recordData) -> recordsTag.m_128365_(uuid.toString(), (Tag)recordData));
        root.m_128365_("AttackRecords", (Tag)recordsTag);
        root.m_128359_("Version", "1.0.0");
        root.m_128356_("SaveTime", System.currentTimeMillis());
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistData(ServerLevel level) {
        try {
            AttackEffectSavedData store = AttackEffectSavedData.get(level);
            Class<AttackEffectManager> clazz = AttackEffectManager.class;
            synchronized (AttackEffectManager.class) {
                store.recordsNBT.clear();
                Map<UUID, CompoundTag> latestData = AttackEffectManager.exportRecords();
                store.recordsNBT.putAll(latestData);
                store.m_77762_();
                AttackEffectManager.markSaved();
                // ** MonitorExit[var2_3] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Failed to persist data to level: {}", level.m_46472_().m_135782_());
            e.printStackTrace();
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadToManager(ServerLevel level) {
        try {
            AttackEffectSavedData store = AttackEffectSavedData.get(level);
            Class<AttackEffectManager> clazz = AttackEffectManager.class;
            synchronized (AttackEffectManager.class) {
                AttackEffectManager.importRecords(store.recordsNBT);
                AttackEffectManager.markSaved();
                // ** MonitorExit[var2_3] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Failed to load data from level: {}", level.m_46472_().m_135782_());
            e.printStackTrace();
        }
        {
            return;
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer serverPlayer;
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && (player = (serverPlayer = (ServerPlayer)player).m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)player;
            if (AttackEffectManager.needsSave()) {
                AttackEffectSavedData.persistData(serverLevel);
            }
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        event.getServer().m_129785_().forEach(AttackEffectSavedData::loadToManager);
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        if (!AttackEffectManager.needsSave()) {
            return;
        }
        event.getServer().m_129785_().forEach(AttackEffectSavedData::persistData);
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            AttackEffectSavedData.loadToManager(serverLevel);
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            if (AttackEffectManager.needsSave()) {
                AttackEffectSavedData.persistData(serverLevel);
            }
        }
    }

    public int getStoredRecordCount() {
        return this.recordsNBT.size();
    }

    public void cleanupExpiredRecords() {
        long currentTime = System.currentTimeMillis();
        long maxAge = 604800000L;
        this.recordsNBT.entrySet().removeIf(entry -> {
            CompoundTag tag = (CompoundTag)entry.getValue();
            if (tag.m_128441_("LastUpdate")) {
                long lastUpdate = tag.m_128454_("LastUpdate");
                return currentTime - lastUpdate > maxAge;
            }
            return false;
        });
        this.m_77762_();
    }

    public String getStatistics() {
        int totalRecords = this.recordsNBT.size();
        int healNegatedCount = 0;
        for (CompoundTag tag : this.recordsNBT.values()) {
            if (!tag.m_128471_("HealNegated")) continue;
            ++healNegatedCount;
        }
        return String.format("Total Records: %d, Heal Negated: %d", totalRecords, healNegatedCount);
    }
}

