/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.attack;

import java.util.function.Predicate;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.the_last_sword.attack.AttackEffectManager;
import net.the_last_sword.client.renderer.AllThingsEndSkyRenderer;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.entity.TheLastEndEntity;
import net.the_last_sword.test.TestEntity;
import net.the_last_sword.util.EntityUtil;

public final class PowerfulRangeAttack {
    private PowerfulRangeAttack() {
    }

    public static void execute(Level lvl, Entity source, Vec3 center) {
        Predicate<Entity> targetFilter = e -> e != source;
        boolean isServer = lvl instanceof ServerLevel;
        AABB box = new AABB(center, center).m_82400_(1024.0);
        if (isServer) {
            ServerLevel server = (ServerLevel)lvl;
            server.m_6443_(Entity.class, box, targetFilter).forEach(e -> {
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    le.m_21219_();
                    le.m_146917_(Integer.MAX_VALUE);
                    le.m_6842_(true);
                }
                e.getPersistentData().m_128379_("NoAI", true);
            });
            server.m_8606_(0, 0, false, false);
            server.m_8615_(6000L);
            for (ServerPlayer sp : server.m_7654_().m_6846_().m_11314_()) {
                sp.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(null, SoundSource.MUSIC));
            }
        }
        if (!isServer && TheLastSwordConfiguration.getEnableRadicalLogicSafely()) {
            AllThingsEndSkyRenderer.forceSkyboxReset();
        }
        lvl.m_6443_(Entity.class, box, targetFilter).forEach(t -> {
            if (t instanceof TheLastEndEntity) {
                TheLastEndEntity theLastEndEntity = (TheLastEndEntity)((Object)t);
                theLastEndEntity.setIsDead(true);
                theLastEndEntity.safeRemove();
                return;
            }
            if (t instanceof TestEntity) {
                TestEntity testEntity = (TestEntity)((Object)t);
                testEntity.safeRemove();
                return;
            }
            if (isServer && t instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)t;
                AttackEffectManager.addReviveBan((Entity)le);
            }
            EntityUtil.TheLastEndRemove(t, Entity.RemovalReason.KILLED);
        });
    }
}

