/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.the_last_sword.init.TheLastSwordModBlocks;
import net.the_last_sword.item.DragonCrystalSoulStone;

@Mod.EventBusSubscriber(modid="the_last_sword")
public class DragonSoulLanternEventHandler {
    private static final double LANTERN_RANGE = 8.0;

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Level level = event.getEntity().m_9236_();
        BlockPos deathPos = event.getEntity().m_20183_();
        if (!DragonSoulLanternEventHandler.hasNearbyDragonSoulLantern(level, deathPos)) {
            return;
        }
        ItemStack emptySoulStone = DragonSoulLanternEventHandler.findEmptySoulStone(player);
        if (emptySoulStone.m_41619_()) {
            return;
        }
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_());
        if (entityId != null) {
            CompoundTag nbt = emptySoulStone.m_41784_();
            nbt.m_128359_("wraith_entity_id", entityId.toString());
            String entityName = event.getEntity().m_8077_() ? event.getEntity().m_7770_().getString() : event.getEntity().m_5446_().getString();
            player.m_213846_((Component)Component.m_237110_((String)"message.the_last_sword.dragon_soul_lantern.stored_success", (Object[])new Object[]{entityName}));
        }
    }

    private static boolean hasNearbyDragonSoulLantern(Level level, BlockPos center) {
        int range = (int)Math.ceil(8.0);
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos checkPos = center.m_7918_(x, y, z);
                    if (!(center.m_123331_((Vec3i)checkPos) <= 64.0) || level.m_8055_(checkPos).m_60734_() != TheLastSwordModBlocks.DRAGON_SOUL_LANTERN.get() || !DragonSoulLanternEventHandler.isLanternActivated(level, checkPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isLanternActivated(Level level, BlockPos lanternPos) {
        BlockPos belowPos = lanternPos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        return belowState.m_60713_(Blocks.f_50080_) || belowState.m_60713_(Blocks.f_50723_);
    }

    private static ItemStack findEmptySoulStone(Player player) {
        ItemStack stack;
        if (player.m_21205_().m_41720_() instanceof DragonCrystalSoulStone && !DragonCrystalSoulStone.hasStoredEntity(stack = player.m_21205_())) {
            return stack;
        }
        if (player.m_21206_().m_41720_() instanceof DragonCrystalSoulStone && !DragonCrystalSoulStone.hasStoredEntity(stack = player.m_21206_())) {
            return stack;
        }
        for (ItemStack stack2 : player.m_150109_().f_35974_) {
            if (!(stack2.m_41720_() instanceof DragonCrystalSoulStone) || DragonCrystalSoulStone.hasStoredEntity(stack2)) continue;
            return stack2;
        }
        return ItemStack.f_41583_;
    }
}

