/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.the_last_sword.capability.SyncedEnergyStorage;

public class ForgeEnergyProvider
implements ICapabilitySerializable<CompoundTag> {
    private final SyncedEnergyStorage energy;
    private final LazyOptional<SyncedEnergyStorage> opt;

    public ForgeEnergyProvider(ItemStack stack, int maxEnergy) {
        this.energy = new SyncedEnergyStorage(stack, maxEnergy);
        this.opt = LazyOptional.of(() -> this.energy);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == ForgeCapabilities.ENERGY ? this.opt.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("energy", this.energy.getEnergyStored());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.energy.receiveEnergy(nbt.m_128451_("energy"), false);
    }
}

